/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.commands.party;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.robertx22.mine_and_slash.uncommon.capability.server_wide.TeamCap;
import com.robertx22.mine_and_slash.uncommon.wrappers.SText;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class PartyCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)"slash").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"party").requires(e -> e.func_197034_c(0))).then(Commands.func_197057_a((String)"list").executes(c -> {
            try {
                ServerPlayerEntity player = ((CommandSource)c.getSource()).func_197035_h();
                if (TeamCap.getCapability().isPlayerInATeam(player)) {
                    SText text = new SText(TextFormatting.GREEN + "Party List: ");
                    List<ITextComponent> list = TeamCap.getCapability().getPlayersInTeam(player).stream().map(x -> x.func_145748_c_()).collect(Collectors.toList());
                    list.forEach(x -> x.func_150258_a(" "));
                    list.forEach(arg_0 -> PartyCommand.lambda$null$3((ITextComponent)text, arg_0));
                    player.func_145747_a((ITextComponent)text);
                } else {
                    player.func_145747_a((ITextComponent)new SText(TextFormatting.GREEN + "You aren't in a party."));
                }
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
            return 0;
        }))).then(Commands.func_197057_a((String)"create").executes(c -> {
            ServerPlayerEntity player = ((CommandSource)c.getSource()).func_197035_h();
            TeamCap.getCapability().createTeam(player);
            player.func_145747_a((ITextComponent)new SText(TextFormatting.GREEN + "Party created. You may now invite players to your party."));
            player.func_145747_a((ITextComponent)new SText(TextFormatting.RED + "Note: you must also use /team as party functionality is currently split."));
            return 0;
        }))).then(Commands.func_197057_a((String)"leave").executes(c -> {
            ServerPlayerEntity player = ((CommandSource)c.getSource()).func_197035_h();
            TeamCap.getCapability().leaveTeam(player);
            player.func_145747_a((ITextComponent)new SText(TextFormatting.GREEN + "You are no longer in a party."));
            return 0;
        }))).then(Commands.func_197057_a((String)"join").then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).executes(c -> {
            ServerPlayerEntity player = ((CommandSource)c.getSource()).func_197035_h();
            ServerPlayerEntity player2 = EntityArgument.func_197089_d((CommandContext)c, (String)"target");
            TeamCap.ITeamData cap = TeamCap.getCapability();
            cap.joinTeam(player, cap.getTeamId(player2));
            player.func_145747_a((ITextComponent)new SText(TextFormatting.GREEN + "A member has joined the party."));
            player2.func_145747_a((ITextComponent)new SText(TextFormatting.GREEN + "You have joined the party."));
            return 0;
        })))).then(Commands.func_197057_a((String)"invite").then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).executes(c -> {
            ServerPlayerEntity player = ((CommandSource)c.getSource()).func_197035_h();
            ServerPlayerEntity player2 = EntityArgument.func_197089_d((CommandContext)c, (String)"target");
            TeamCap.ITeamData cap = TeamCap.getCapability();
            cap.invite(player2, cap.getTeamId(player));
            player.func_145747_a((ITextComponent)new SText(TextFormatting.GREEN + "Invitation sent."));
            player2.func_145747_a((ITextComponent)new SText(TextFormatting.GREEN + "You have been invited to a party!"));
            player2.func_145747_a((ITextComponent)new SText(TextFormatting.GREEN + "Type '/slash party join <player>'" + TextFormatting.GREEN + " to accept."));
            return 0;
        })))));
    }

    private static /* synthetic */ void lambda$null$3(ITextComponent text, ITextComponent x) {
        text.func_150257_a(x);
    }
}

