/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.config.base;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.mmorpg.registers.common.ConfigRegister;
import com.robertx22.mine_and_slash.packets.SyncConfigToClientPacket;
import com.robertx22.mine_and_slash.registry.ISlashRegistryInit;
import com.robertx22.mine_and_slash.saveclasses.ListStringData;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.SerializationUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.player.ServerPlayerEntity;

public interface ISerializedConfig<T extends ISlashRegistryInit> {
    public String fileName();

    default public String getPath() {
        return this.folder() + "/" + this.fileName();
    }

    public T getDefaultObject();

    default public String getJsonFromFile(String path) {
        try {
            return new String(Files.readAllBytes(Paths.get(path, new String[0])));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public T loadFromString(String var1);

    default public List<String> getAllJsons() {
        return Arrays.asList(this.getJsonFromFile(this.getPath()));
    }

    public ConfigRegister.Config getConfigType();

    default public void loadOnServer() {
        List<String> jsons = this.getAllJsons();
        ConfigRegister.SAVED_JSONS.put(this.getConfigType(), jsons);
        this.getAllJsons().forEach(x -> this.loadFromString((String)x).registerAll());
    }

    default public boolean isSyncedToClient() {
        return true;
    }

    default public void sendToClient(ServerPlayerEntity player) {
        if (this.isSyncedToClient()) {
            List<String> configs = ConfigRegister.SAVED_JSONS.get((Object)this.getConfigType());
            SyncConfigToClientPacket pkt = new SyncConfigToClientPacket(new ListStringData(configs), this.getConfigType());
            MMORPG.sendToClient(pkt, player);
        }
    }

    default public String folder() {
        return SerializationUtils.CONFIG_PATH;
    }

    default public void autoFixProblems() {
    }

    default public void generateIfEmpty() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson(this.getDefaultObject());
        SerializationUtils.makeFileAndDirAndWrite(this.folder(), this.fileName(), json);
    }

    default public void loadFromJsons(List<String> list) {
        list.forEach(x -> this.loadFromString((String)x).registerAll());
    }
}

