/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.config.base_player_stat;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.robertx22.mine_and_slash.config.base.ISerializedConfig;
import com.robertx22.mine_and_slash.config.base_player_stat.BasePlayerStatContainer;
import com.robertx22.mine_and_slash.mmorpg.registers.common.ConfigRegister;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.SerializationUtils;
import java.util.HashSet;
import java.util.Map;

public class BasePlayerStatSerial
implements ISerializedConfig<BasePlayerStatContainer> {
    public static BasePlayerStatSerial INSTANCE = new BasePlayerStatSerial();

    @Override
    public String fileName() {
        return "BasePlayerStats.txt";
    }

    @Override
    public BasePlayerStatContainer getDefaultObject() {
        return BasePlayerStatContainer.defaultStats();
    }

    @Override
    public BasePlayerStatContainer loadFromString(String string) {
        return (BasePlayerStatContainer)new Gson().fromJson(string, BasePlayerStatContainer.class);
    }

    @Override
    public void autoFixProblems() {
        BasePlayerStatContainer currentConfig = this.loadFromString(this.getJsonFromFile(this.getPath()));
        BasePlayerStatContainer defaultConfig = this.getDefaultObject();
        new HashSet<Map.Entry<String, Double>>(currentConfig.PLAYER_STATS_THAT_SCALE_TO_LEVEL.entrySet()).stream().filter(x -> !SlashRegistry.Stats().isRegistered((String)x.getKey())).forEach(p -> currentConfig.PLAYER_STATS_THAT_SCALE_TO_LEVEL.remove(p.getKey()));
        new HashSet<Map.Entry<String, Double>>(currentConfig.BASE_PLAYER_STATS.entrySet()).stream().filter(x -> !SlashRegistry.Stats().isRegistered((String)x.getKey())).forEach(p -> currentConfig.BASE_PLAYER_STATS.remove(p.getKey()));
        defaultConfig.BASE_PLAYER_STATS.entrySet().forEach(x -> {
            if (!currentConfig.BASE_PLAYER_STATS.containsKey(x.getKey())) {
                currentConfig.BASE_PLAYER_STATS.put((String)x.getKey(), (Double)x.getValue());
            }
        });
        defaultConfig.PLAYER_STATS_THAT_SCALE_TO_LEVEL.entrySet().forEach(x -> {
            if (!currentConfig.PLAYER_STATS_THAT_SCALE_TO_LEVEL.containsKey(x.getKey())) {
                currentConfig.PLAYER_STATS_THAT_SCALE_TO_LEVEL.put((String)x.getKey(), (Double)x.getValue());
            }
        });
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson((Object)currentConfig);
        SerializationUtils.makeFileAndDirAndWrite(this.folder(), this.fileName(), json, true);
    }

    @Override
    public ConfigRegister.Config getConfigType() {
        return ConfigRegister.Config.BASE_PLAYER_STATS;
    }
}

