/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.config.forge;

import com.robertx22.mine_and_slash.uncommon.enumclasses.Masteries;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.EntityType;
import net.minecraftforge.common.ForgeConfigSpec;

public class ServerContainer {
    public ForgeConfigSpec.BooleanValue USE_COMPATIBILITY_ITEMS;
    public ForgeConfigSpec.BooleanValue DISABLE_VANILLA_HP_REGEN;
    public ForgeConfigSpec.BooleanValue GENERATE_ORES;
    public ForgeConfigSpec.IntValue DELETE_DUNGEON_DIMENSION_FOLDER_AFTER_X_MAPS_SACRIFICED;
    public ForgeConfigSpec.BooleanValue ONLY_REPAIR_IN_STATION;
    public ForgeConfigSpec.BooleanValue LOG_REGISTRY_ENTRIES;
    public ForgeConfigSpec.BooleanValue ENABLE_CURRENCY_ITEMS_BREAKING_MODIFIED_ITEMS;
    public ForgeConfigSpec.BooleanValue ENABLE_CURRENCY_ITEMS_INSTABILITY_SYSTEM;
    public ForgeConfigSpec.IntValue MAXIMUM_WORN_RUNED_ITEMS;
    public ForgeConfigSpec.IntValue MAXIMUM_WORN_UNIQUE_ITEMS;
    public ForgeConfigSpec.IntValue MAPS_DROP_AFTER_LEVEL;
    public ForgeConfigSpec.IntValue CURRENCY_DROP_AFTER_LEVEL;
    public ForgeConfigSpec.IntValue RUNES_AND_RUNED_GEAR_DROP_AFTER_LEVEL;
    public ForgeConfigSpec.IntValue MAXIMUM_PLAYER_LEVEL;
    public ForgeConfigSpec.IntValue MAXIMUM_ITEM_INSTABILITY;
    public ForgeConfigSpec.IntValue FUEL_NEEDED_PER_MAP_ACTIVATION;
    public ForgeConfigSpec.IntValue TALENT_POINTS_AT_MAX_LEVEL;
    public ForgeConfigSpec.IntValue SPELL_POINTS_AT_MAX_LEVEL;
    public ForgeConfigSpec.IntValue STARTING_SPELL_POINTS;
    public ForgeConfigSpec.DoubleValue STAT_POINTS_PER_LEVEL;
    public ForgeConfigSpec.DoubleValue MOB_BOSS_CHANCE_IN_MAPS;
    public ForgeConfigSpec.DoubleValue NON_MOD_DAMAGE_MULTI;
    public ForgeConfigSpec.DoubleValue XP_LOSS_ON_DEATH;
    public ForgeConfigSpec.DoubleValue MOB_ENVIRONMENT_DAMAGE_MULTI;
    public ForgeConfigSpec.DoubleValue NON_MOD_HEAL_MULTI;
    public ForgeConfigSpec.DoubleValue EXPERIENCE_MULTIPLIER;
    public ForgeConfigSpec.DoubleValue UNARMED_ENERGY_COST;
    public ForgeConfigSpec.DoubleValue PLAYER_HEART_TO_HEALTH_CONVERSION;
    public ForgeConfigSpec.DoubleValue STAT_REQUIREMENTS_MULTI;
    public ForgeConfigSpec.DoubleValue MAP_EVENT_CHANCE_PER_MINUTE;
    public ForgeConfigSpec.DoubleValue REPAIR_FUEL_NEEDED_MULTI;
    public ForgeConfigSpec.DoubleValue MOB_STRENGTH_PER_LEVEL_MULTI;
    public ForgeConfigSpec.DoubleValue REGEN_HUNGER_COST;
    public ForgeConfigSpec.ConfigValue<List<? extends String>> IGNORED_ENTITIES;

    ServerContainer(ForgeConfigSpec.Builder builder) {
        builder.push("GENERAL");
        ArrayList<EntityType> list = new ArrayList<EntityType>();
        list.add(EntityType.field_200791_e);
        list.add(EntityType.field_204262_at);
        list.add(EntityType.field_203779_Z);
        list.add(EntityType.field_203778_ae);
        list.add(EntityType.field_203780_j);
        list.add(EntityType.field_200749_ao);
        list.add(EntityType.field_200736_ab);
        List idlist = list.stream().map(x -> x.getRegistryName().toString()).collect(Collectors.toList());
        this.IGNORED_ENTITIES = builder.comment(".").translation("mmorpg.word.").defineList("IGNORED_ENTITIES", idlist, x -> true);
        this.REGEN_HUNGER_COST = builder.comment(".").translation("mmorpg.word.").defineInRange("REGEN_HUNGER_COST", 3.0, 0.0, 1000.0);
        this.MOB_STRENGTH_PER_LEVEL_MULTI = builder.comment("This makes mobs increasingly stronger, by default at lvl 100 mobs will be 50% stronger, formula works as multiplying by 1 + [CONFIG_VALUE]").translation("mmorpg.word.").defineInRange("MOB_STRENGTH_PER_LEVEL_MULTI", (double)0.005f, 0.0, 1.0);
        this.FUEL_NEEDED_PER_MAP_ACTIVATION = builder.comment("").translation("mmorpg.word.").defineInRange("FUEL_NEEDED_PER_MAP_ACTIVATION", 2500, 0, 100000);
        this.REPAIR_FUEL_NEEDED_MULTI = builder.comment(".").translation("mmorpg.word.").defineInRange("REPAIR_FUEL_NEEDED_MULTI", 1.0, 0.0, 100000.0);
        this.MAP_EVENT_CHANCE_PER_MINUTE = builder.comment(".").translation("mmorpg.word.").defineInRange("MAP_EVENT_CHANCE_PER_MINUTE", 10.0, 0.0, 100.0);
        this.MOB_BOSS_CHANCE_IN_MAPS = builder.comment(".").translation("mmorpg.word.").defineInRange("MOB_BOSS_CHANCE_IN_MAPS", 0.2, 0.0, 100.0);
        this.STAT_POINTS_PER_LEVEL = builder.comment(".").translation("mmorpg.word.").defineInRange("STAT_POINTS_PER_LEVEL", 1.5, 0.0, 100.0);
        this.TALENT_POINTS_AT_MAX_LEVEL = builder.comment(".").translation("mmorpg.word.").defineInRange("TALENT_POINTS_AT_MAX_LEVEL", 120, 0, 10000);
        this.SPELL_POINTS_AT_MAX_LEVEL = builder.comment(".").translation("mmorpg.word.").defineInRange("SPELL_POINTS_AT_MAX_LEVEL", Masteries.MAXIMUM_POINTS * 2 + 80, 0, 1000);
        this.STARTING_SPELL_POINTS = builder.comment(".").translation("mmorpg.word.").defineInRange("STARTING_SPELL_POINTS", 3, 0, Integer.MAX_VALUE);
        this.PLAYER_HEART_TO_HEALTH_CONVERSION = builder.comment(".").translation("mmorpg.word.").defineInRange("PLAYER_HEART_TO_HEALTH_CONVERSION", 1.0, 0.0, 100.0);
        this.STAT_REQUIREMENTS_MULTI = builder.comment(".").translation("mmorpg.word.").defineInRange("STAT_REQUIREMENTS_MULTI", 1.0, 0.0, 100.0);
        this.XP_LOSS_ON_DEATH = builder.comment(".").translation("mmorpg.word.").defineInRange("XP_LOSS_ON_DEATH", 0.25, 0.0, 1.0);
        this.ENABLE_CURRENCY_ITEMS_BREAKING_MODIFIED_ITEMS = builder.comment(".").define("ENABLE_CURRENCY_ITEMS_BREAKING_MODIFIED_ITEMS", true);
        this.LOG_REGISTRY_ENTRIES = builder.comment(".").define("LOG_REGISTRY_ENTRIES", false);
        this.ENABLE_CURRENCY_ITEMS_INSTABILITY_SYSTEM = builder.comment(".").define("ENABLE_CURRENCY_ITEMS_INSTABILITY_SYSTEM", true);
        this.DELETE_DUNGEON_DIMENSION_FOLDER_AFTER_X_MAPS_SACRIFICED = builder.comment(".").translation("mmorpg.word").defineInRange("DELETE_DUNGEON_DIMENSION_FOLDER_AFTER_X_MAPS_SACRIFICED", 5000, 0, 500000);
        this.ONLY_REPAIR_IN_STATION = builder.comment(".").define("ONLY_REPAIR_IN_STATION", true);
        this.DISABLE_VANILLA_HP_REGEN = builder.comment(".").translation("mmorpg.word.entities").define("DISABLE_VANILLA_HP_REGEN", true);
        this.USE_COMPATIBILITY_ITEMS = builder.comment(".").translation("mmorpg.word.").define("USE_COMPATIBILITY_ITEMS", true);
        this.GENERATE_ORES = builder.comment(".").translation("mmorpg.word.").define("GENERATE_ORES", true);
        this.MAXIMUM_WORN_RUNED_ITEMS = builder.comment(".").translation("mmorpg.word.").defineInRange("MAXIMUM_WORN_RUNED_ITEMS", 3, 0, Integer.MAX_VALUE);
        this.MAXIMUM_WORN_UNIQUE_ITEMS = builder.comment(".").translation("mmorpg.word.").defineInRange("MAXIMUM_WORN_UNIQUE_ITEMS", 4, 0, Integer.MAX_VALUE);
        this.MAPS_DROP_AFTER_LEVEL = builder.comment(".").translation("mmorpg.word.").defineInRange("MAPS_DROP_AFTER_LEVEL", 10, 0, Integer.MAX_VALUE);
        this.MAXIMUM_ITEM_INSTABILITY = builder.comment(".").translation("mmorpg.word.").defineInRange("MAXIMUM_ITEM_INSTABILITY", 500, 0, Integer.MAX_VALUE);
        this.CURRENCY_DROP_AFTER_LEVEL = builder.comment(".").translation("mmorpg.word.").defineInRange("CURRENCY_DROP_AFTER_LEVEL", 10, 0, Integer.MAX_VALUE);
        this.RUNES_AND_RUNED_GEAR_DROP_AFTER_LEVEL = builder.comment(".").translation("mmorpg.word.").defineInRange("RUNES_AND_RUNED_GEAR_DROP_AFTER_LEVEL", 8, 0, Integer.MAX_VALUE);
        this.MAXIMUM_PLAYER_LEVEL = builder.comment(".").translation("mmorpg.word.").defineInRange("MAXIMUM_PLAYER_LEVEL", 60, 0, Integer.MAX_VALUE);
        this.NON_MOD_DAMAGE_MULTI = builder.comment(".").translation("mmorpg.word.").defineInRange("NON_MOD_DAMAGE_MULTI", 0.0, 0.0, 2.147483647E9);
        this.MOB_ENVIRONMENT_DAMAGE_MULTI = builder.comment(".").translation("mmorpg.word.").defineInRange("MOB_ENVIRONMENT_DAMAGE_MULTI", 0.2, 0.0, 2.147483647E9);
        this.NON_MOD_HEAL_MULTI = builder.comment(".").translation("mmorpg.word.").defineInRange("NON_MOD_HEAL_MULTI", 0.1, 0.0, 2.147483647E9);
        this.EXPERIENCE_MULTIPLIER = builder.comment(".").translation("mmorpg.word.").defineInRange("EXPERIENCE_MULTIPLIER", 1.0, 0.0, 2.147483647E9);
        this.UNARMED_ENERGY_COST = builder.comment(".").translation("mmorpg.word.").defineInRange("UNARMED_ENERGY_COST", 1.5, 0.0, 2.147483647E9);
        builder.pop();
    }
}

