/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.config.forge.parts;

import com.robertx22.mine_and_slash.config.forge.parts.AutoConfigItemType;
import net.minecraftforge.common.ForgeConfigSpec;

public class AutoCompatibleItemConfig {
    public ForgeConfigSpec.BooleanValue ENABLE_AUTOMATIC_COMPATIBLE_ITEMS;
    public ForgeConfigSpec.IntValue MAX_SINGLE_STAT_VALUE;
    public ForgeConfigSpec.IntValue MAX_TOTAL_STATS;
    public AutoConfigItemType HORRIBLE;
    public AutoConfigItemType TRASH;
    public AutoConfigItemType NORMAL;
    public AutoConfigItemType BEST;

    public AutoCompatibleItemConfig(ForgeConfigSpec.Builder builder) {
        builder.push("AUTO_ITEM_COMPATIBILITY");
        this.ENABLE_AUTOMATIC_COMPATIBLE_ITEMS = builder.comment("This automatically makes items compatible that i can recognize automatically, meaning they extend from vanilla classes.").define("ENABLE_AUTOMATIC_COMPATIBLE_ITEMS", false);
        this.MAX_TOTAL_STATS = builder.comment("Used in power level calculation. Total stats of an item are capped to this value to prevent the median being offset too much by god items.").defineInRange("MAX_TOTAL_STATS", 200, 0, 100000);
        this.MAX_SINGLE_STAT_VALUE = builder.defineInRange("MAX_SINGLE_STAT_VALUE", 50, 0, 100000);
        this.HORRIBLE = (AutoConfigItemType)builder.comment("").configure(b -> new AutoConfigItemType(0.0f, (ForgeConfigSpec.Builder)b, "HORRIBLE", 20, 0, 0)).getLeft();
        this.TRASH = (AutoConfigItemType)builder.comment("").configure(b -> new AutoConfigItemType(0.03f, (ForgeConfigSpec.Builder)b, "TRASH", 40, 0, 2)).getLeft();
        this.NORMAL = (AutoConfigItemType)builder.comment("").configure(b -> new AutoConfigItemType(0.3f, (ForgeConfigSpec.Builder)b, "NORMAL", 80, 0, 4)).getLeft();
        this.BEST = (AutoConfigItemType)builder.comment("").configure(b -> new AutoConfigItemType(0.8f, (ForgeConfigSpec.Builder)b, "BEST", Integer.MAX_VALUE, 1, 4)).getLeft();
        builder.pop();
    }
}

