/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.config.forge.parts;

import com.robertx22.mine_and_slash.data_generation.compatible_items.CompatibleItem;
import com.robertx22.mine_and_slash.database.gearitemslots.bases.GearItemSlot;
import net.minecraft.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;

public class AutoConfigItemType {
    public ForgeConfigSpec.IntValue MAX_LEVEL;
    public ForgeConfigSpec.DoubleValue POWER_REQ;
    public ForgeConfigSpec.IntValue MIN_RARITY;
    public ForgeConfigSpec.IntValue MAX_RARITY;
    public ForgeConfigSpec.BooleanValue CAN_BE_SALVAGED;

    public AutoConfigItemType(float req, ForgeConfigSpec.Builder builder, String type, int maxlvl, int minrar, int maxrar) {
        builder.push(type);
        this.MAX_LEVEL = builder.defineInRange("MAX_LEVEL", maxlvl, 0, Integer.MAX_VALUE);
        this.POWER_REQ = builder.defineInRange("POWER_REQ", (double)req, 0.0, 1.0);
        this.MIN_RARITY = builder.defineInRange("MIN_RARITY", minrar, 0, 4);
        this.MAX_RARITY = builder.defineInRange("MAX_RARITY", maxrar, 0, 4);
        this.CAN_BE_SALVAGED = builder.define("CAN_BE_SALVAGED", false);
        builder.pop();
    }

    public CompatibleItem getAutoCompatibleItem(Item item, GearItemSlot slot) {
        CompatibleItem comp = CompatibleItem.getDefaultAuto(item, slot);
        comp.max_rarity = (Integer)this.MAX_RARITY.get();
        comp.min_rarity = (Integer)this.MIN_RARITY.get();
        comp.max_level = (Integer)this.MAX_LEVEL.get();
        comp.can_be_salvaged = (Boolean)this.CAN_BE_SALVAGED.get();
        return comp;
    }
}

