/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.data_generation;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.robertx22.mine_and_slash.onevent.data_gen.providers.SlashDataProvider;
import com.robertx22.mine_and_slash.registry.ISlashRegistryEntry;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.registry.SlashRegistryContainer;
import com.robertx22.mine_and_slash.registry.SlashRegistryType;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.Cached;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.data.DataGenerator;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BaseDataPackManager<T extends ISlashRegistryEntry>
extends JsonReloadListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().create();
    String id;
    Function<JsonObject, T> serializer;
    SlashRegistryType registryType;

    public BaseDataPackManager(SlashRegistryType registryType, String id, Function<JsonObject, T> serializer) {
        super(GSON, id);
        this.id = id;
        this.serializer = serializer;
        this.registryType = registryType;
    }

    public abstract SlashDataProvider getDataPackCreator(DataGenerator var1);

    protected void apply(Map<ResourceLocation, JsonObject> mapToLoad, IResourceManager manager, IProfiler profilerIn) {
        Cached.reset();
        SlashRegistryContainer reg = SlashRegistry.getRegistry(this.registryType);
        reg.unregisterAllEntriesFromDatapacks();
        mapToLoad.forEach((loc, json) -> {
            try {
                ISlashRegistryEntry object = (ISlashRegistryEntry)this.serializer.apply((JsonObject)json);
                object.registerToSlashRegistry();
            }
            catch (Exception exception) {
                LOGGER.error("Couldn't parse " + this.id + " {}", loc, (Object)exception);
            }
        });
        if (reg.isEmpty()) {
            throw new RuntimeException("Mine and Slash Registry of type " + this.registryType.id + " is EMPTY after datapack loading!");
        }
        System.out.println(this.registryType.name() + " Registry succeeded loading: " + reg.getSize() + " datapack entries.");
    }
}

