/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.data_generation;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.robertx22.mine_and_slash.database.stats.StatMod;
import com.robertx22.mine_and_slash.onevent.data_gen.ISerializablePart;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class JsonUtils {
    public static void addStatMods(List<StatMod> mods, JsonObject json, String id) {
        JsonArray array = new JsonArray();
        mods.stream().map(x -> x.GUID()).collect(Collectors.toList()).forEach(x -> array.add(x));
        json.add(id, (JsonElement)array);
    }

    public static List<StatMod> getStatMods(JsonObject json, String id) {
        ArrayList<StatMod> mods = new ArrayList<StatMod>();
        json.getAsJsonArray(id).forEach(x -> mods.add(SlashRegistry.StatMods().get(x.getAsString())));
        return mods;
    }

    public static JsonArray stringListToJsonArray(List<String> list) {
        JsonArray json = new JsonArray();
        list.forEach(x -> json.add((JsonElement)new JsonPrimitive(x)));
        return json;
    }

    public static List<String> jsonArrayToStringList(JsonArray json) {
        ArrayList<String> list = new ArrayList<String>();
        json.forEach(x -> list.add(x.getAsString()));
        return list;
    }

    public static <T extends ISerializablePart> JsonArray partListToJsonArray(List<T> list) {
        JsonArray json = new JsonArray();
        list.forEach(x -> json.add((JsonElement)x.toJson()));
        return json;
    }

    public static List<ISerializablePart> jsonArrayToPartList(JsonArray json, List<ISerializablePart> possibleParts) {
        ArrayList<ISerializablePart> list = new ArrayList<ISerializablePart>();
        json.forEach(element -> {
            if (element != null && element.getAsJsonObject() != null) {
                possibleParts.forEach(part -> {
                    Object newobj = null;
                    try {
                        newobj = part.fromJson(element.getAsJsonObject());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (newobj instanceof ISerializablePart) {
                        list.add(newobj);
                    }
                });
            }
        });
        return list;
    }
}

