/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.data_generation.compatible_items;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.robertx22.mine_and_slash.config.compatible_items.WeightedType;
import com.robertx22.mine_and_slash.database.gearitemslots.bases.GearItemSlot;
import com.robertx22.mine_and_slash.database.unique_items.IUnique;
import com.robertx22.mine_and_slash.loot.blueprints.GearBlueprint;
import com.robertx22.mine_and_slash.loot.blueprints.RunedGearBlueprint;
import com.robertx22.mine_and_slash.loot.blueprints.UniqueGearBlueprint;
import com.robertx22.mine_and_slash.onevent.data_gen.ISerializable;
import com.robertx22.mine_and_slash.onevent.data_gen.ISerializedRegistryEntry;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.registry.SlashRegistryType;
import com.robertx22.mine_and_slash.saveclasses.gearitem.GearItemEnum;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Gear;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class CompatibleItem
implements ISerializable<CompatibleItem>,
ISerializedRegistryEntry<CompatibleItem> {
    public static CompatibleItem EMPTY = new CompatibleItem();
    public String item_type = "sword";
    public String guid = "guid_for_this_entry";
    public String item_id = "item_id";
    public int unique_item_weight = 0;
    public int normal_item_weight = 80;
    public int runed_item_weight = 20;
    public int min_rarity = 0;
    public int max_rarity = 4;
    public boolean only_add_stats_if_loot_drop = false;
    public boolean add_to_loot_drops = true;
    public int loot_drop_weight = 1000;
    public boolean can_be_salvaged = false;
    public int level_variance = 0;
    public int min_level = 1;
    public int max_level = Integer.MAX_VALUE;
    public int if_unique_random_up_to_tier = 10;
    public String unique_id = "";

    public static CompatibleItem getDefaultAuto(Item item, GearItemSlot slot) {
        CompatibleItem comp = new CompatibleItem();
        comp.item_type = slot.GUID();
        comp.item_id = item.getRegistryName().toString();
        comp.guid = slot.GUID() + ":" + comp.item_id;
        comp.level_variance = 3;
        comp.add_to_loot_drops = false;
        return comp;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("item_type", this.item_type);
        json.addProperty("item_id", this.item_id);
        json.addProperty("id", this.guid);
        JsonObject gearType = new JsonObject();
        gearType.addProperty("normal_item_weight", (Number)this.normal_item_weight);
        gearType.addProperty("runed_item_weight", (Number)this.runed_item_weight);
        gearType.addProperty("unique_item_weight", (Number)this.unique_item_weight);
        json.add("gear_type", (JsonElement)gearType);
        JsonObject rarity = new JsonObject();
        rarity.addProperty("min_rarity", (Number)this.min_rarity);
        rarity.addProperty("max_rarity", (Number)this.max_rarity);
        json.add("rarity", (JsonElement)rarity);
        JsonObject Misc = new JsonObject();
        Misc.addProperty("only_add_stats_if_loot_drop", Boolean.valueOf(this.only_add_stats_if_loot_drop));
        Misc.addProperty("add_to_loot_drops", Boolean.valueOf(this.add_to_loot_drops));
        Misc.addProperty("loot_drop_weight", (Number)this.loot_drop_weight);
        Misc.addProperty("can_be_salvaged", Boolean.valueOf(this.can_be_salvaged));
        json.add("misc", (JsonElement)Misc);
        JsonObject level = new JsonObject();
        level.addProperty("min_level", (Number)this.min_level);
        level.addProperty("max_level", (Number)this.max_level);
        level.addProperty("level_variance", (Number)this.level_variance);
        json.add("level", (JsonElement)level);
        JsonObject unique = new JsonObject();
        unique.addProperty("if_unique_random_up_to_tier", (Number)this.if_unique_random_up_to_tier);
        unique.addProperty("unique_id", this.unique_id);
        json.add("unique", (JsonElement)unique);
        return json;
    }

    @Override
    public CompatibleItem fromJson(JsonObject json) {
        CompatibleItem obj = new CompatibleItem();
        obj.item_type = json.get("item_type").getAsString();
        obj.item_id = json.get("item_id").getAsString();
        obj.guid = this.getGUIDFromJson(json);
        JsonObject gearType = json.getAsJsonObject("gear_type");
        obj.normal_item_weight = gearType.get("normal_item_weight").getAsInt();
        obj.runed_item_weight = gearType.get("runed_item_weight").getAsInt();
        obj.unique_item_weight = gearType.get("unique_item_weight").getAsInt();
        JsonObject rarity = json.getAsJsonObject("rarity");
        obj.min_rarity = rarity.get("min_rarity").getAsInt();
        obj.max_rarity = rarity.get("max_rarity").getAsInt();
        JsonObject misc = json.getAsJsonObject("misc");
        obj.only_add_stats_if_loot_drop = misc.get("only_add_stats_if_loot_drop").getAsBoolean();
        obj.add_to_loot_drops = misc.get("add_to_loot_drops").getAsBoolean();
        obj.loot_drop_weight = misc.get("loot_drop_weight").getAsInt();
        obj.can_be_salvaged = misc.get("can_be_salvaged").getAsBoolean();
        JsonObject level = json.getAsJsonObject("level");
        obj.min_level = level.get("min_level").getAsInt();
        obj.max_level = level.get("max_level").getAsInt();
        obj.level_variance = level.get("level_variance").getAsInt();
        JsonObject unique = json.getAsJsonObject("unique");
        obj.if_unique_random_up_to_tier = unique.get("if_unique_random_up_to_tier").getAsInt();
        obj.unique_id = unique.get("unique_id").getAsString();
        return obj;
    }

    @Override
    public String datapackFolder() {
        return new ResourceLocation(this.item_id).func_110624_b() + "/";
    }

    @Override
    public SlashRegistryType getSlashRegistryType() {
        return SlashRegistryType.COMPATIBLE_ITEM;
    }

    @Override
    public boolean isFromDatapack() {
        return true;
    }

    public String getFileName() {
        return new ResourceLocation(this.item_id).func_110623_a();
    }

    @Override
    public String GUID() {
        return this.guid;
    }

    public ItemStack create(ItemStack stack, int level) {
        level = this.getLevel(level);
        switch (this.getCreationType()) {
            case NORMAL: {
                this.createNormal(stack, level);
                break;
            }
            case UNIQUE: {
                this.createUnique(stack, level);
                break;
            }
            case RUNED: {
                this.createRuned(stack, level);
            }
        }
        return stack;
    }

    private GearItemEnum getCreationType() {
        WeightedType result = RandomUtils.weightedRandom(Arrays.asList(new WeightedType(this.normal_item_weight, GearItemEnum.NORMAL), new WeightedType(this.unique_item_weight, GearItemEnum.UNIQUE), new WeightedType(this.runed_item_weight, GearItemEnum.RUNED)));
        return result.type;
    }

    private int getLevel(int playerlevel) {
        return MathHelper.func_76125_a((int)playerlevel, (int)this.min_level, (int)this.max_level);
    }

    private ItemStack createNormal(ItemStack stack, int level) {
        GearBlueprint blueprint = new GearBlueprint(level);
        blueprint.gearItemSlot.set(this.item_type);
        blueprint.level.LevelRange = this.level_variance > 0;
        blueprint.level.LevelVariance = this.level_variance;
        blueprint.rarity.minRarity = this.min_rarity;
        blueprint.rarity.maxRarity = this.max_rarity;
        GearItemData gear = blueprint.createData();
        gear.isSalvagable = this.can_be_salvaged;
        gear.isNotFromMyMod = true;
        Gear.Save(stack, gear);
        return stack;
    }

    private ItemStack createUnique(ItemStack stack, int level) {
        UniqueGearBlueprint blueprint = null;
        blueprint = SlashRegistry.UniqueGears().isRegistered(this.unique_id) ? new UniqueGearBlueprint(level, SlashRegistry.UniqueGears().get(this.unique_id)) : new UniqueGearBlueprint(level, this.if_unique_random_up_to_tier);
        blueprint.gearItemSlot.set(this.item_type);
        blueprint.level.LevelRange = this.level_variance > 0;
        blueprint.level.LevelVariance = this.level_variance;
        GearItemData gear = blueprint.createData();
        gear.isSalvagable = this.can_be_salvaged;
        gear.isNotFromMyMod = true;
        if (gear.uniqueGUID == null || !SlashRegistry.UniqueGears().isRegistered(gear.uniqueGUID)) {
            return this.createNormal(stack, level);
        }
        Gear.Save(stack, gear);
        return stack;
    }

    private ItemStack createRuned(ItemStack stack, int level) {
        RunedGearBlueprint blueprint = new RunedGearBlueprint(level);
        blueprint.gearItemSlot.set(this.item_type);
        blueprint.level.LevelRange = this.level_variance > 0;
        blueprint.level.LevelVariance = this.level_variance;
        blueprint.rarity.minRarity = this.min_rarity;
        blueprint.rarity.maxRarity = this.max_rarity;
        GearItemData gear = blueprint.createData();
        gear.isSalvagable = this.can_be_salvaged;
        gear.isNotFromMyMod = true;
        Gear.Save(stack, gear);
        return stack;
    }

    @Override
    public boolean isRegistryEntryValid() {
        List<IUnique> possible;
        if (!SlashRegistry.GearTypes().isRegistered(this.item_type)) {
            System.out.println("Invalid gear slot: " + this.item_type);
            return false;
        }
        if (!this.unique_id.isEmpty() && !SlashRegistry.UniqueGears().isRegistered(this.unique_id)) {
            System.out.println("Invalid unique gear id: " + this.unique_id);
            return false;
        }
        if (this.unique_id.isEmpty() && this.unique_item_weight > 0 && (possible = SlashRegistry.UniqueGears().getFiltered(x -> x.getGearSlot().GUID().equals(this.item_type) && x.getTier() <= this.if_unique_random_up_to_tier)).isEmpty()) {
            System.out.println("There are no possible random uniques for item type of: " + this.item_type + " of unique tier of " + this.if_unique_random_up_to_tier + " or less.");
            System.out.println("This won't prevent the compatible item from functioning, but it means whenever it tries to generate as unique, it will turn to fallback normal item.");
            return true;
        }
        return true;
    }
}

