/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.data_generation.models;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.robertx22.mine_and_slash.data_generation.models.IAutoModel;
import com.robertx22.mine_and_slash.database.gearitemslots.bases.GearItemSlot;
import com.robertx22.mine_and_slash.database.gearitemslots.offhand.Shield;
import com.robertx22.mine_and_slash.database.gearitemslots.weapons.Bow;
import com.robertx22.mine_and_slash.database.gearitemslots.weapons.CrossBow;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ExistingFileHelper;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemModelManager
extends ItemModelProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public ItemModelManager(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "mmorpg", existingFileHelper);
    }

    protected void registerModels() {
        ForgeRegistries.ITEMS.forEach(x -> {
            if (x instanceof IAutoModel) {
                IAutoModel auto = (IAutoModel)x;
                auto.generateModel(this);
            }
        });
        SlashRegistry.UniqueGears().getSerializable().forEach(x -> {
            if (x.getGearSlot() != Bow.INSTANCE && x.getGearSlot() != CrossBow.INSTANCE) {
                if (x.getGearSlot().slotType().equals((Object)GearItemSlot.GearSlotType.Weapon)) {
                    this.handheld(x.getUniqueItem());
                } else {
                    this.generated(x.getItemForRegistration());
                }
            }
        });
        SlashRegistry.GearTypes().getList().forEach(x -> x.getItemsForRaritiesMap().values().forEach(i -> {
            if (x != Bow.INSTANCE && x != CrossBow.INSTANCE && x != Shield.INSTANCE && !x.GUID().contains("cloth") && !x.GUID().contains("leather")) {
                if (x.slotType().equals((Object)GearItemSlot.GearSlotType.Weapon)) {
                    this.handheld((Item)i);
                } else {
                    this.generated((Item)i);
                }
            }
        }));
    }

    public String func_200397_b() {
        return "Mine and Slash Item Models";
    }

    public String modid(Item item) {
        return item.func_199767_j().getRegistryName().func_110624_b();
    }

    public String name(Item item) {
        return item.func_199767_j().getRegistryName().func_110623_a();
    }

    public ItemModelBuilder generated(Item item) {
        return this.generated(item, this.itemTexture(item));
    }

    public ItemModelBuilder generated(Item item, ResourceLocation ... layers) {
        ItemModelBuilder ret = (ItemModelBuilder)this.withExistingParent(this.name(item), "item/generated");
        for (int i = 0; i < layers.length; ++i) {
            ret = (ItemModelBuilder)ret.texture("layer" + i, layers[i]);
        }
        return ret;
    }

    public ResourceLocation itemTexture(Item item) {
        return this.modLoc("items/" + this.name(item));
    }

    public ResourceLocation overlay(Item item) {
        return this.modLoc("items/" + this.name(item) + "_overlay");
    }

    public ItemModelBuilder handheld(Item item) {
        return this.handheld(item, this.itemTexture(item));
    }

    public ItemModelBuilder handheld(Item item, ResourceLocation texture) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.name(item), "item/handheld")).texture("layer0", texture);
    }

    protected void generateAll(DirectoryCache cache) {
        for (ItemModelBuilder model : this.generatedModels.values()) {
            Path target = this.getPath(model);
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)model.toJson(), (Path)target);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Path getPath(ItemModelBuilder model) {
        ResourceLocation loc = model.getLocation();
        return this.generator.func_200391_b().resolve("assets/" + loc.func_110624_b() + "/models/item/" + loc.func_110623_a() + ".json");
    }
}

