/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.data_generation.unique_gears;

import com.robertx22.mine_and_slash.database.gearitemslots.bases.GearItemSlot;
import com.robertx22.mine_and_slash.database.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.stats.StatMod;
import com.robertx22.mine_and_slash.database.unique_items.IUnique;
import com.robertx22.mine_and_slash.database.unique_items.StatReq;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class SerializableUniqueGear
implements IUnique {
    List<StatMod> primaryStats;
    List<StatMod> uniqueStats;
    int tier;
    int rarity;
    int weight;
    boolean canGetSet;
    StatReq requirements;
    String guid;
    String langNameID;
    String langDescID;
    String gearType;
    ResourceLocation itemID;

    public SerializableUniqueGear(List<StatMod> primaryStats, List<StatMod> uniqueStats, int tier, GearRarity rarity, int weight, boolean canGetSet, StatReq requirements, String guid, String langNameID, String langDescID, String gearType, ResourceLocation itemID) {
        this.primaryStats = primaryStats;
        this.uniqueStats = uniqueStats;
        this.tier = tier;
        this.rarity = rarity.Rank();
        this.weight = weight;
        this.canGetSet = canGetSet;
        this.requirements = requirements;
        this.guid = guid;
        this.langNameID = langNameID.contains("item.") ? langNameID : "item." + langNameID;
        this.langDescID = langDescID.contains("item.") ? langDescID : "item." + langDescID;
        this.gearType = gearType;
        this.itemID = itemID;
    }

    @Override
    public boolean canGetSet() {
        return this.canGetSet;
    }

    @Override
    public ResourceLocation getResourceLocForItem() {
        return this.itemID;
    }

    @Override
    public Item getUniqueItem() {
        return (Item)ForgeRegistries.ITEMS.getValue(this.itemID);
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public List<StatMod> uniqueStats() {
        return this.uniqueStats;
    }

    @Override
    public List<StatMod> primaryStats() {
        return this.primaryStats;
    }

    @Override
    public StatReq getRequirements() {
        return this.requirements;
    }

    @Override
    public String locDescForLangFile() {
        return "";
    }

    @Override
    public String locNameForLangFile() {
        return "";
    }

    @Override
    public String locDescLangFileGUID() {
        return this.langDescID;
    }

    @Override
    public String locNameLangFileGUID() {
        return this.langNameID;
    }

    @Override
    public String GUID() {
        return this.guid;
    }

    @Override
    public GearItemSlot getGearSlot() {
        return SlashRegistry.GearTypes().get(this.gearType);
    }
}

