/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.data_generation.wrappers;

import com.google.gson.JsonObject;
import com.robertx22.mine_and_slash.database.rarities.RuneRarity;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.onevent.data_gen.ISerializable;
import java.util.HashMap;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemPerRarityHolder
implements ISerializable<ItemPerRarityHolder> {
    public static ISerializable<ItemPerRarityHolder> SERIALIZER = new ItemPerRarityHolder();
    HashMap<Integer, String> map = new HashMap();
    HashMap<Integer, Item> itemMapForRegistration = new HashMap();

    public HashMap<Integer, Item> getForRegistration() {
        return this.itemMapForRegistration;
    }

    public ItemPerRarityHolder(HashMap<Integer, Item> itemMap) {
        this.itemMapForRegistration = new HashMap<Integer, Item>(itemMap);
        itemMap.entrySet().forEach(e -> this.map.put((Integer)e.getKey(), ((Item)e.getValue()).getRegistryName().toString()));
    }

    private ItemPerRarityHolder() {
    }

    public Item get(int rarity) {
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.map.get(rarity)));
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        this.map.entrySet().forEach(x -> json.addProperty(x.getKey() + "", (String)x.getValue()));
        return json;
    }

    @Override
    public ItemPerRarityHolder fromJson(JsonObject json) {
        HashMap<Integer, Item> itemMap = new HashMap<Integer, Item>();
        for (RuneRarity rar : Rarities.Runes.getAllRarities()) {
            String id = rar.Rank() + "";
            if (!json.has(id)) continue;
            String itemid = json.get(id).getAsString();
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemid));
            itemMap.put(rar.Rank(), item);
        }
        return new ItemPerRarityHolder(itemMap);
    }
}

