/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database;

import java.util.Locale;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public interface IGUID {
    public String GUID();

    default public String formattedGUID() {
        return this.formatString(this.GUID());
    }

    default public String formatString(String str) {
        return IGUID.getformattedString(str);
    }

    default public String getFormatedForLangFile(String str) {
        return str.replaceAll(" ", "_").toLowerCase(Locale.ROOT).replaceAll("/", ".").replaceAll(":", ".");
    }

    public static String getformattedString(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return IGUID.addUnderscoresBehindUppercase(str).replaceAll(" ", "_").replaceAll("__", "_").toLowerCase(Locale.ROOT);
    }

    public static String addUnderscoresBehindUppercase(String str) {
        String s = "";
        int i = 0;
        boolean addedUnderscore = true;
        for (char c : str.toCharArray()) {
            if (Character.isUpperCase(c) && i > 0 && !addedUnderscore) {
                s = s + "_" + c;
                addedUnderscore = true;
            } else {
                s = s + c;
                if (!Character.isUpperCase(c)) {
                    addedUnderscore = false;
                }
            }
            ++i;
        }
        return s;
    }

    default public Item getFromForgeRegistry() {
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("mmorpg", this.GUID()));
    }

    default public boolean isGuidFormattedCorrectly() {
        if (this.GUID() == null) {
            System.out.println("Null guid detected!!! " + this.getClass().toString());
        }
        return IGUID.isGUIDFormattedCorrectly(this.GUID());
    }

    public static boolean isGUIDFormattedCorrectly(String id) {
        for (char c : id.toCharArray()) {
            if (IGUID.isValidPathCharacter(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidPathCharacter(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c == '_' || c == ':' || c == '/' || c == '.' || c == '-';
    }
}

