/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.affixes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.robertx22.mine_and_slash.data_generation.JsonUtils;
import com.robertx22.mine_and_slash.data_generation.affixes.SerializableAffix;
import com.robertx22.mine_and_slash.database.IGUID;
import com.robertx22.mine_and_slash.database.requirements.LevelRequirement;
import com.robertx22.mine_and_slash.database.requirements.Requirements;
import com.robertx22.mine_and_slash.database.requirements.bases.BaseRequirement;
import com.robertx22.mine_and_slash.database.stats.StatMod;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.db_lists.bases.IhasRequirements;
import com.robertx22.mine_and_slash.onevent.data_gen.ISerializable;
import com.robertx22.mine_and_slash.onevent.data_gen.ISerializedRegistryEntry;
import com.robertx22.mine_and_slash.registry.SlashRegistryType;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.Rarity;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocName;
import com.robertx22.mine_and_slash.uncommon.interfaces.IBaseAutoLoc;
import com.robertx22.mine_and_slash.uncommon.interfaces.IWeighted;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.IRarity;
import java.util.List;
import java.util.Optional;

public abstract class BaseAffix
implements IWeighted,
IGUID,
IAutoLocName,
IhasRequirements,
IRarity,
ISerializedRegistryEntry<BaseAffix>,
ISerializable<BaseAffix> {
    public Type type;
    Requirements requirements;

    public BaseAffix(Requirements requirements, Type type) {
        this.requirements = requirements;
        this.type = type;
    }

    @Override
    public boolean isFromDatapack() {
        return true;
    }

    @Override
    public SlashRegistryType getSlashRegistryType() {
        return SlashRegistryType.AFFIX;
    }

    @Override
    public abstract String GUID();

    @Override
    public String locNameLangFileGUID() {
        return "mmorpg.affix." + this.formattedGUID();
    }

    @Override
    public final IBaseAutoLoc.AutoLocGroup locNameGroup() {
        return IBaseAutoLoc.AutoLocGroup.Affixes;
    }

    @Override
    public final Requirements requirements() {
        return this.requirements;
    }

    public LevelRequirement getLevelRequirement() {
        Optional<BaseRequirement> opt = this.requirements.requirements.stream().filter(x -> x instanceof LevelRequirement).findAny();
        if (opt.isPresent()) {
            return (LevelRequirement)opt.get();
        }
        return LevelRequirement.none();
    }

    @Override
    public int Weight() {
        return this.getRarity().Weight();
    }

    public abstract List<StatMod> StatMods();

    @Override
    public int getRarityRank() {
        return 1;
    }

    @Override
    public Rarity getRarity() {
        return Rarities.Gears.get(this.getRarityRank());
    }

    @Override
    public boolean isRegistryEntryValid() {
        return this.checkStatModsValidity(this.StatMods());
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = this.getDefaultJson();
        json.addProperty("type", this.type.name());
        json.add("requirements", (JsonElement)this.requirements().toJson());
        JsonUtils.addStatMods(this.StatMods(), json, "mods");
        return json;
    }

    @Override
    public BaseAffix fromJson(JsonObject json) {
        try {
            String guid = this.getGUIDFromJson(json);
            String langName = this.getLangNameStringFromJson(json);
            int weight = this.getWeightFromJson(json);
            int rarity = this.getRarityFromJson(json);
            Type type = Type.valueOf(json.get("type").getAsString());
            Requirements req = Requirements.EMPTY.fromJson(json.getAsJsonObject("requirements"));
            List<StatMod> mods = JsonUtils.getStatMods(json, "mods");
            return new SerializableAffix(rarity, weight, req, guid, mods, langName, type);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static enum Type {
        prefix,
        suffix;

    }
}

