/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.bosses.base;

import com.robertx22.mine_and_slash.database.bosses.base.BossData;
import com.robertx22.mine_and_slash.database.bosses.base.TickAction;
import com.robertx22.mine_and_slash.database.spells.synergies.base.Synergy;
import com.robertx22.mine_and_slash.registry.ISlashRegistryEntry;
import com.robertx22.mine_and_slash.registry.SlashRegistryType;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IApplyableStats;
import com.robertx22.mine_and_slash.uncommon.capability.entity.BossCap;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public abstract class Boss
implements ISlashRegistryEntry<Boss>,
IApplyableStats {
    public boolean isFire = false;
    public List<Synergy> synergies = new ArrayList<Synergy>();
    public List<TickAction> tickActions = new ArrayList<TickAction>();

    public final void onTick(LivingEntity en) {
        if (en instanceof MobEntity) {
            MobEntity mob = (MobEntity)en;
            if (mob.func_70638_az() != null) {
                this.tickActions.forEach(x -> x.onTick(en));
            }
        } else {
            this.tickActions.forEach(x -> x.onTick(en));
        }
    }

    public abstract IParticleData getParticle();

    public abstract ITextComponent getName();

    public final ITextComponent getNameFor(LivingEntity en) {
        return this.getName().func_150258_a(" ").func_150257_a(en.func_145748_c_());
    }

    public void onSpawn(LivingEntity en) {
    }

    public void onDeath(LivingEntity en) {
    }

    public abstract void onHealthTreshholdTriggered(LivingEntity var1, BossData.HealthTreshhold var2);

    public void spawnMinion(BlockPos p, MobEntity minion, World world) {
        minion.func_70107_b((double)p.func_177958_n(), (double)p.func_177956_o(), (double)p.func_177952_p());
        minion.getCapability(BossCap.Data).ifPresent(x -> x.setIsBoss(false));
        minion.func_213386_a((IWorld)world, world.func_175649_E(p), SpawnReason.REINFORCEMENT, null, (CompoundNBT)null);
        world.func_217376_c((Entity)minion);
    }

    @Override
    public SlashRegistryType getSlashRegistryType() {
        return SlashRegistryType.BOSS;
    }

    @Override
    public void applyStats(EntityCap.UnitData data, int level) {
    }

    public boolean hasSynergy(Synergy synergy) {
        return this.synergies.contains(synergy);
    }
}

