/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.bosses.base;

import com.robertx22.mine_and_slash.database.bosses.base.Boss;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.uncommon.capability.entity.BossCap;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import net.minecraft.entity.LivingEntity;

@Storable
public class BossData {
    @Store
    public String boss;
    @Store
    public boolean hp_10 = false;
    @Store
    public boolean hp_25 = false;
    @Store
    public boolean hp_50 = false;
    @Store
    public boolean hp_75 = false;

    public Boss getBoss() {
        return SlashRegistry.Bosses().get(this.boss);
    }

    public void onHealthChanged(LivingEntity en, BossCap.IBossData bossData) {
        Boss boss = this.getBoss();
        int perc = this.getHealthPercent(en);
        if (!this.hp_75 && perc < 75) {
            this.hp_75 = true;
            boss.onHealthTreshholdTriggered(en, HealthTreshhold.T_75);
            return;
        }
        if (!this.hp_50 && perc < 50) {
            this.hp_50 = true;
            boss.onHealthTreshholdTriggered(en, HealthTreshhold.T_50);
            return;
        }
        if (!this.hp_25 && perc < 25) {
            this.hp_25 = true;
            boss.onHealthTreshholdTriggered(en, HealthTreshhold.T_25);
            return;
        }
        if (!this.hp_10 && perc < 10) {
            this.hp_10 = true;
            boss.onHealthTreshholdTriggered(en, HealthTreshhold.T_10);
            return;
        }
    }

    private int getHealthPercent(LivingEntity en) {
        return (int)(en.func_110143_aJ() / en.func_110138_aP() * 100.0f);
    }

    public static enum HealthTreshhold {
        T_10,
        T_25,
        T_50,
        T_75;

    }
}

