/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.currency;

import com.robertx22.mine_and_slash.advacements.PlayerLevelTrigger;
import com.robertx22.mine_and_slash.database.currency.base.CurrencyItem;
import com.robertx22.mine_and_slash.database.currency.base.ICurrencyItemEffect;
import com.robertx22.mine_and_slash.database.currency.base.IShapedRecipe;
import com.robertx22.mine_and_slash.database.currency.loc_reqs.BaseLocRequirement;
import com.robertx22.mine_and_slash.database.currency.loc_reqs.GearEnumLocReq;
import com.robertx22.mine_and_slash.database.currency.loc_reqs.SimpleGearLocReq;
import com.robertx22.mine_and_slash.database.currency.loc_reqs.item_types.GearReq;
import com.robertx22.mine_and_slash.items.SimpleMatItem;
import com.robertx22.mine_and_slash.items.ores.ItemOre;
import com.robertx22.mine_and_slash.mmorpg.registers.common.ModItems;
import com.robertx22.mine_and_slash.saveclasses.gearitem.ChaosStatsData;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Gear;
import com.robertx22.mine_and_slash.uncommon.interfaces.IRenamed;
import java.util.Arrays;
import java.util.List;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;

public class ChaosOrbItem
extends CurrencyItem
implements ICurrencyItemEffect,
IRenamed,
IShapedRecipe {
    public static final String ID = "mmorpg:currency/chaos_orb";

    @Override
    public String GUID() {
        return "currency/chaos_orb";
    }

    @Override
    public List<String> oldNames() {
        return Arrays.asList("mmorpg:chaos_orb");
    }

    public ChaosOrbItem() {
        super(ID);
    }

    @Override
    public ItemStack ModifyItem(ItemStack stack, ItemStack Currency) {
        GearItemData gear = Gear.Load(stack);
        gear.chaosStats = new ChaosStatsData();
        gear.chaosStats.RerollFully(gear);
        Gear.Save(stack, gear);
        return stack;
    }

    @Override
    public List<BaseLocRequirement> requirements() {
        return Arrays.asList(GearReq.INSTANCE, GearEnumLocReq.CAN_CHAOS_STATS, SimpleGearLocReq.NO_CHAOS_STATS);
    }

    @Override
    public int getTier() {
        return 2;
    }

    @Override
    public List<String> loreLines() {
        return Arrays.asList("Do not gamble what you are not willing to lose.");
    }

    @Override
    public String locNameForLangFile() {
        return nameColor + "Chaos Orb";
    }

    @Override
    public String locDescForLangFile() {
        return "Permanently adds a Chaos stat";
    }

    @Override
    public int instabilityAddAmount() {
        return -25;
    }

    @Override
    public boolean activatesBreakRoll() {
        return false;
    }

    @Override
    public ShapedRecipeBuilder getRecipe() {
        return this.shaped((IItemProvider)ModItems.CHAOS_ORB.get()).func_200462_a(Character.valueOf('#'), (IItemProvider)SimpleMatItem.INFUSED_IRON).func_200462_a(Character.valueOf('t'), (IItemProvider)ModItems.ORB_OF_TRANSMUTATION.get()).func_200462_a(Character.valueOf('b'), (IItemProvider)Items.field_151075_bm).func_200462_a(Character.valueOf('o'), (IItemProvider)ItemOre.ItemOres.get(1)).func_200472_a("ooo").func_200472_a("#t#").func_200472_a("bbb").func_200465_a("player_level", (ICriterionInstance)new PlayerLevelTrigger.Instance(10));
    }
}

