/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.currency;

import com.robertx22.mine_and_slash.advacements.PlayerLevelTrigger;
import com.robertx22.mine_and_slash.database.currency.base.CurrencyItem;
import com.robertx22.mine_and_slash.database.currency.base.ICurrencyItemEffect;
import com.robertx22.mine_and_slash.database.currency.base.IShapedRecipe;
import com.robertx22.mine_and_slash.database.currency.loc_reqs.BaseLocRequirement;
import com.robertx22.mine_and_slash.database.currency.loc_reqs.SimpleGearLocReq;
import com.robertx22.mine_and_slash.database.currency.loc_reqs.item_types.GearReq;
import com.robertx22.mine_and_slash.items.SimpleMatItem;
import com.robertx22.mine_and_slash.items.ores.ItemOre;
import com.robertx22.mine_and_slash.mmorpg.registers.common.ModItems;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Gear;
import com.robertx22.mine_and_slash.uncommon.interfaces.IRenamed;
import java.util.Arrays;
import java.util.List;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;

public class CrystalOfAscensionItem
extends CurrencyItem
implements ICurrencyItemEffect,
IRenamed,
IShapedRecipe {
    private static final String name = "mmorpg:currency/item_levelup";
    public static final int MAXIMUM_LEVEL_UPS = 15;

    @Override
    public String GUID() {
        return "currency/item_levelup";
    }

    @Override
    public List<String> oldNames() {
        return Arrays.asList("mmorpg:item_levelup");
    }

    public CrystalOfAscensionItem() {
        super(name);
    }

    @Override
    public ItemStack ModifyItem(ItemStack stack, ItemStack Currency) {
        GearItemData gear = Gear.Load(stack);
        gear.setLevel(gear.level + 1);
        ++gear.timesLeveledUp;
        Gear.Save(stack, gear);
        return stack;
    }

    @Override
    public int getRarityRank() {
        return 3;
    }

    @Override
    public List<BaseLocRequirement> requirements() {
        return Arrays.asList(GearReq.INSTANCE, SimpleGearLocReq.LVLED_LESS_THAN_10_TIMES, SimpleGearLocReq.LEVEL_ISNT_HIGHER_THAN_MAX);
    }

    @Override
    public int getTier() {
        return 2;
    }

    @Override
    public List<String> loreLines() {
        return Arrays.asList("Who said your sword can't level with you?");
    }

    @Override
    public String locNameForLangFile() {
        return nameColor + "Crystal Of Ascension";
    }

    @Override
    public String locDescForLangFile() {
        return "Increases item level";
    }

    @Override
    public int instabilityAddAmount() {
        return 5;
    }

    @Override
    public ShapedRecipeBuilder getRecipe() {
        return this.shaped((IItemProvider)ModItems.CRYSTAL_OF_ASCENSION.get()).func_200462_a(Character.valueOf('#'), (IItemProvider)SimpleMatItem.GOLDEN_ORB).func_200462_a(Character.valueOf('t'), (IItemProvider)ModItems.ORB_OF_TRANSMUTATION.get()).func_200462_a(Character.valueOf('b'), (IItemProvider)Items.field_151075_bm).func_200462_a(Character.valueOf('o'), (IItemProvider)ItemOre.ItemOres.get(1)).func_200472_a("ooo").func_200472_a("#t#").func_200472_a(" b ").func_200465_a("player_level", (ICriterionInstance)new PlayerLevelTrigger.Instance(10));
    }
}

