/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.currency;

import com.robertx22.mine_and_slash.advacements.PlayerLevelTrigger;
import com.robertx22.mine_and_slash.database.currency.base.CurrencyItem;
import com.robertx22.mine_and_slash.database.currency.base.ICurrencyItemEffect;
import com.robertx22.mine_and_slash.database.currency.base.IShapedRecipe;
import com.robertx22.mine_and_slash.database.currency.loc_reqs.BaseLocRequirement;
import com.robertx22.mine_and_slash.database.currency.loc_reqs.SimpleGearLocReq;
import com.robertx22.mine_and_slash.database.rarities.gears.UniqueGear;
import com.robertx22.mine_and_slash.items.SimpleMatItem;
import com.robertx22.mine_and_slash.items.ores.ItemOre;
import com.robertx22.mine_and_slash.loot.blueprints.UniqueGearBlueprint;
import com.robertx22.mine_and_slash.mmorpg.registers.common.ModItems;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Gear;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocMultiLore;
import com.robertx22.mine_and_slash.uncommon.interfaces.IRenamed;
import java.util.Arrays;
import java.util.List;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;

public class GemOfUniqueHeaven
extends CurrencyItem
implements ICurrencyItemEffect,
IRenamed,
IAutoLocMultiLore,
IShapedRecipe {
    private static final String GUID = "mmorpg:currency/create_new_unique";

    @Override
    public List<String> oldNames() {
        return Arrays.asList("mmorpg:create_new_unique");
    }

    @Override
    public String GUID() {
        return "currency/create_new_unique";
    }

    public GemOfUniqueHeaven() {
        super(GUID);
    }

    @Override
    public ItemStack ModifyItem(ItemStack stack, ItemStack Currency) {
        GearItemData gear = Gear.Load(stack);
        UniqueGearBlueprint gearPrint = new UniqueGearBlueprint(gear.level, gear.uniqueStats.getUnique().getTier(), false);
        gearPrint.rarity.setSpecificRarity(UniqueGear.getInstance().Rank());
        gearPrint.level.LevelRange = false;
        ItemStack newstack = gearPrint.createStack();
        GearItemData newgear = gearPrint.createData();
        for (int tries = 0; newgear.gearTypeName.equals(gear.gearTypeName) && tries < 10; ++tries) {
            newgear = gearPrint.createData();
            newstack = gearPrint.createStack();
        }
        gear.WriteOverDataThatShouldStay(newgear);
        return newstack;
    }

    @Override
    public List<BaseLocRequirement> requirements() {
        return Arrays.asList(SimpleGearLocReq.IS_UNIQUE);
    }

    @Override
    public int getTier() {
        return 3;
    }

    @Override
    public int getRarityRank() {
        return 4;
    }

    @Override
    public List<String> loreLines() {
        return Arrays.asList("Don't want it? Transform it!");
    }

    @Override
    public String locNameForLangFile() {
        return nameColor + "Gem Of Unique Heaven";
    }

    @Override
    public String locDescForLangFile() {
        return "Transform unique (same tier)";
    }

    @Override
    public int instabilityAddAmount() {
        return 0;
    }

    @Override
    public ShapedRecipeBuilder getRecipe() {
        return this.shaped((IItemProvider)ModItems.GEM_OF_UNIQUE_HEAVEN.get()).func_200462_a(Character.valueOf('#'), (IItemProvider)SimpleMatItem.MYTHIC_ESSENCE).func_200462_a(Character.valueOf('t'), (IItemProvider)ModItems.STONE_OF_HOPE.get()).func_200462_a(Character.valueOf('v'), (IItemProvider)Items.field_151043_k).func_200462_a(Character.valueOf('o'), (IItemProvider)ItemOre.ItemOres.get(2)).func_200472_a("ooo").func_200472_a("#t#").func_200472_a("vvv").func_200465_a("player_level", (ICriterionInstance)new PlayerLevelTrigger.Instance(10));
    }
}

