/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.currency;

import com.robertx22.mine_and_slash.advacements.PlayerLevelTrigger;
import com.robertx22.mine_and_slash.database.currency.base.CurrencyItem;
import com.robertx22.mine_and_slash.database.currency.base.ICurrencyItemEffect;
import com.robertx22.mine_and_slash.database.currency.base.IShapedRecipe;
import com.robertx22.mine_and_slash.database.currency.loc_reqs.BaseLocRequirement;
import com.robertx22.mine_and_slash.database.currency.loc_reqs.GearEnumLocReq;
import com.robertx22.mine_and_slash.database.currency.loc_reqs.item_types.GearReq;
import com.robertx22.mine_and_slash.items.SimpleMatItem;
import com.robertx22.mine_and_slash.items.ores.ItemOre;
import com.robertx22.mine_and_slash.mmorpg.registers.common.ModItems;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Gear;
import java.util.Arrays;
import java.util.List;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;

public class OrbOfForgetfulnessItem
extends CurrencyItem
implements ICurrencyItemEffect,
IShapedRecipe {
    private static final String name = "mmorpg:currency/clear_runes";

    @Override
    public String GUID() {
        return "currency/clear_runes";
    }

    public OrbOfForgetfulnessItem() {
        super(name);
    }

    @Override
    public ItemStack ModifyItem(ItemStack stack, ItemStack Currency) {
        GearItemData gear = Gear.Load(stack);
        gear.runes.clearRunes();
        Gear.Save(stack, gear);
        return stack;
    }

    @Override
    public List<BaseLocRequirement> requirements() {
        return Arrays.asList(GearReq.INSTANCE, GearEnumLocReq.RUNED);
    }

    @Override
    public int getTier() {
        return 3;
    }

    @Override
    public int getRarityRank() {
        return 4;
    }

    @Override
    public List<String> loreLines() {
        return Arrays.asList("If only we could re-write the past.");
    }

    @Override
    public String locNameForLangFile() {
        return nameColor + "Orb of Forgetfulness";
    }

    @Override
    public String locDescForLangFile() {
        return "Clears runes and runewords from an item.";
    }

    @Override
    public int instabilityAddAmount() {
        return 10;
    }

    @Override
    public ShapedRecipeBuilder getRecipe() {
        return this.shaped((IItemProvider)ModItems.ORB_OF_FORGETFULNESS.get()).func_200462_a(Character.valueOf('#'), (IItemProvider)SimpleMatItem.GOLDEN_ORB).func_200462_a(Character.valueOf('t'), (IItemProvider)ModItems.ORB_OF_TRANSMUTATION.get()).func_200462_a(Character.valueOf('v'), (IItemProvider)Items.field_151079_bi).func_200462_a(Character.valueOf('o'), (IItemProvider)ItemOre.ItemOres.get(4)).func_200472_a("o#o").func_200472_a("oto").func_200472_a("v#v").func_200465_a("player_level", (ICriterionInstance)new PlayerLevelTrigger.Instance(10));
    }
}

