/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.currency;

import com.robertx22.mine_and_slash.advacements.PlayerLevelTrigger;
import com.robertx22.mine_and_slash.database.currency.base.CurrencyItem;
import com.robertx22.mine_and_slash.database.currency.base.ICurrencyItemEffect;
import com.robertx22.mine_and_slash.database.currency.base.IShapedRecipe;
import com.robertx22.mine_and_slash.database.currency.loc_reqs.BaseLocRequirement;
import com.robertx22.mine_and_slash.database.currency.loc_reqs.SimpleGearLocReq;
import com.robertx22.mine_and_slash.database.currency.loc_reqs.item_types.GearReq;
import com.robertx22.mine_and_slash.items.SimpleMatItem;
import com.robertx22.mine_and_slash.items.ores.ItemOre;
import com.robertx22.mine_and_slash.mmorpg.registers.common.ModItems;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Gear;
import java.util.Arrays;
import java.util.List;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;

public class StoneOfCorruptionItem
extends CurrencyItem
implements ICurrencyItemEffect,
IShapedRecipe {
    public static final String ID = "mmorpg:currency/cheap_gear_lvl";

    @Override
    public String GUID() {
        return "currency/cheap_gear_lvl";
    }

    public StoneOfCorruptionItem() {
        super(ID);
    }

    @Override
    public ItemStack ModifyItem(ItemStack stack, ItemStack Currency) {
        GearItemData gear = Gear.Load(stack);
        gear.setLevel(gear.getLevel() + 5);
        Gear.Save(stack, gear);
        return stack;
    }

    @Override
    public List<BaseLocRequirement> requirements() {
        return Arrays.asList(GearReq.INSTANCE, SimpleGearLocReq.LEVEL_ISNT_HIGHER_THAN_MAX);
    }

    @Override
    public int getTier() {
        return 1;
    }

    @Override
    public int getRarityRank() {
        return 3;
    }

    @Override
    public List<String> loreLines() {
        return Arrays.asList("Impatience breeds failure.");
    }

    @Override
    public String locNameForLangFile() {
        return nameColor + "Stone of Corruption";
    }

    @Override
    public String locDescForLangFile() {
        return "Increase Gear lvl by 5";
    }

    @Override
    public int instabilityAddAmount() {
        return 500;
    }

    @Override
    public float additionalBreakChance() {
        return 20.0f;
    }

    @Override
    public ShapedRecipeBuilder getRecipe() {
        return this.shaped((IItemProvider)ModItems.STONE_OF_CORRUPTION.get()).func_200462_a(Character.valueOf('#'), (IItemProvider)SimpleMatItem.INFUSED_IRON).func_200462_a(Character.valueOf('t'), (IItemProvider)ModItems.ORB_OF_TRANSMUTATION.get()).func_200462_a(Character.valueOf('b'), (IItemProvider)Items.field_151042_j).func_200462_a(Character.valueOf('o'), (IItemProvider)ItemOre.ItemOres.get(1)).func_200472_a("ooo").func_200472_a("#t#").func_200472_a(" b ").func_200465_a("player_level", (ICriterionInstance)new PlayerLevelTrigger.Instance(10));
    }
}

