/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.currency;

import com.robertx22.mine_and_slash.advacements.PlayerLevelTrigger;
import com.robertx22.mine_and_slash.database.currency.base.CurrencyItem;
import com.robertx22.mine_and_slash.database.currency.base.ICurrencyItemEffect;
import com.robertx22.mine_and_slash.database.currency.base.IShapedRecipe;
import com.robertx22.mine_and_slash.database.currency.loc_reqs.BaseLocRequirement;
import com.robertx22.mine_and_slash.database.currency.loc_reqs.SimpleGearLocReq;
import com.robertx22.mine_and_slash.database.currency.loc_reqs.item_types.GearReq;
import com.robertx22.mine_and_slash.items.SimpleMatItem;
import com.robertx22.mine_and_slash.items.ores.ItemOre;
import com.robertx22.mine_and_slash.loot.blueprints.GearBlueprint;
import com.robertx22.mine_and_slash.loot.gens.util.GearCreationUtils;
import com.robertx22.mine_and_slash.mmorpg.registers.common.ModItems;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Gear;
import com.robertx22.mine_and_slash.uncommon.interfaces.IRenamed;
import java.util.Arrays;
import java.util.List;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;

public class StoneOfHopeItem
extends CurrencyItem
implements ICurrencyItemEffect,
IRenamed,
IShapedRecipe {
    public static final String ID = "mmorpg:currency/stone_of_hope";

    @Override
    public String GUID() {
        return "currency/stone_of_hope";
    }

    @Override
    public List<String> oldNames() {
        return Arrays.asList("mmorpg:stone_of_hope");
    }

    public StoneOfHopeItem() {
        super(ID);
    }

    @Override
    public ItemStack ModifyItem(ItemStack stack, ItemStack Currency) {
        GearItemData gear = Gear.Load(stack);
        GearBlueprint blueprint = new GearBlueprint(gear.level);
        blueprint.gearItemSlot.set(gear.gearTypeName);
        blueprint.rarity.minRarity = gear.Rarity + 1;
        blueprint.level.LevelRange = false;
        GearItemData newgear = blueprint.createData();
        gear.WriteOverDataThatShouldStay(newgear);
        ItemStack result = ItemStack.field_190927_a;
        if (gear.changesItemStack()) {
            result = GearCreationUtils.CreateStack(newgear);
        } else {
            result = stack;
            Gear.Save(result, newgear);
        }
        return result;
    }

    @Override
    public List<BaseLocRequirement> requirements() {
        return Arrays.asList(GearReq.INSTANCE, SimpleGearLocReq.IS_LOWER_THAN_LEGENDARY, SimpleGearLocReq.IS_NOT_UNIQUE);
    }

    @Override
    public int getRarityRank() {
        return 4;
    }

    @Override
    public int getTier() {
        return 2;
    }

    @Override
    public List<String> loreLines() {
        return Arrays.asList("When there is hope, there is a way.");
    }

    @Override
    public String locNameForLangFile() {
        return nameColor + "Stone Of Hope";
    }

    @Override
    public String locDescForLangFile() {
        return "Transform any rarity gear into higher rarity";
    }

    @Override
    public float additionalBreakChance() {
        return 25.0f;
    }

    @Override
    public int instabilityAddAmount() {
        return 0;
    }

    @Override
    public ShapedRecipeBuilder getRecipe() {
        return this.shaped((IItemProvider)ModItems.STONE_OF_HOPE.get()).func_200462_a(Character.valueOf('#'), (IItemProvider)SimpleMatItem.MYTHIC_ESSENCE).func_200462_a(Character.valueOf('t'), (IItemProvider)ModItems.ORB_OF_TRANSMUTATION.get()).func_200462_a(Character.valueOf('v'), (IItemProvider)Items.field_151045_i).func_200462_a(Character.valueOf('o'), (IItemProvider)ItemOre.ItemOres.get(4)).func_200472_a("#o#").func_200472_a("#t#").func_200472_a("vvv").func_200465_a("player_level", (ICriterionInstance)new PlayerLevelTrigger.Instance(10));
    }
}

