/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.currency.base;

import com.robertx22.mine_and_slash.config.forge.ModConfig;
import com.robertx22.mine_and_slash.data_generation.models.IAutoModel;
import com.robertx22.mine_and_slash.data_generation.models.ItemModelManager;
import com.robertx22.mine_and_slash.database.currency.base.IAddsInstability;
import com.robertx22.mine_and_slash.database.currency.base.ICurrencyItemEffect;
import com.robertx22.mine_and_slash.database.currency.loc_reqs.BaseLocRequirement;
import com.robertx22.mine_and_slash.database.currency.loc_reqs.LocReqContext;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.items.ItemDefault;
import com.robertx22.mine_and_slash.registry.ISlashRegistryEntry;
import com.robertx22.mine_and_slash.registry.SlashRegistryType;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.Rarity;
import com.robertx22.mine_and_slash.uncommon.datasaving.ItemType;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocDesc;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocMultiLore;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocName;
import com.robertx22.mine_and_slash.uncommon.interfaces.IBaseAutoLoc;
import com.robertx22.mine_and_slash.uncommon.interfaces.IWeighted;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.ISalvagable;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.ITiered;
import com.robertx22.mine_and_slash.uncommon.localization.Styles;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RecipeUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class CurrencyItem
extends Item
implements IAddsInstability,
ISlashRegistryEntry<CurrencyItem>,
ISalvagable,
ICurrencyItemEffect,
IWeighted,
ITiered,
IAutoLocMultiLore,
IAutoLocDesc,
IAutoLocName,
IAutoModel {
    public ItemType itemTypesUsableOn = ItemType.GEAR;
    public static TextFormatting nameColor = TextFormatting.RED;

    @Override
    public abstract String GUID();

    public CurrencyItem(String name) {
        super(new ItemDefault().func_200917_a(64));
    }

    @Override
    public void generateModel(ItemModelManager manager) {
        manager.generated(this);
    }

    @Override
    public final boolean canItemBeModified(LocReqContext context) {
        if (!this.itemTypesUsableOn.isType(context.stack)) {
            return false;
        }
        for (BaseLocRequirement req : this.requirements()) {
            if (!req.isNotAllowed(context)) continue;
            return false;
        }
        return true;
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locDescGroup() {
        return IBaseAutoLoc.AutoLocGroup.Currency_Items;
    }

    @Override
    public String locDescLangFileGUID() {
        return this.getRegistryName().toString() + ".desc";
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locLoresGroup() {
        return IBaseAutoLoc.AutoLocGroup.Currency_Items;
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locNameGroup() {
        return IBaseAutoLoc.AutoLocGroup.Currency_Items;
    }

    @Override
    public String locNameLangFileGUID() {
        return this.getRegistryName().toString();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CurrencyItem auto;
        if (this instanceof IAutoLocMultiLore) {
            auto = this;
            for (ITextComponent comp : auto.getComponents()) {
                tooltip.add(Styles.GREENCOMP().func_150258_a("'").func_150257_a(comp).func_150258_a("'"));
            }
        }
        if (this instanceof IAutoLocDesc) {
            auto = this;
            tooltip.add(Styles.YELLOWCOMP().func_150257_a(auto.locDesc()));
        }
        tooltip.add(ItemType.getTooltipString(this.itemTypesUsableOn));
        TooltipUtils.addEmpty(tooltip);
        tooltip.add(TooltipUtils.tier(this.getTier()));
        tooltip.add(TooltipUtils.rarity(this.getRarity()));
        TooltipUtils.addEmpty(tooltip);
        if (this instanceof IAddsInstability && ((Boolean)ModConfig.INSTANCE.Server.ENABLE_CURRENCY_ITEMS_INSTABILITY_SYSTEM.get()).booleanValue()) {
            tooltip.add(Styles.REDCOMP().func_150258_a("Adds " + this.instabilityAddAmount() + " Instability"));
        }
        TooltipUtils.addEmpty(tooltip);
        tooltip.add(Styles.BLUECOMP().func_150257_a(Words.Item_modifiable_in_station.locName()));
        TooltipUtils.addEmpty(tooltip);
    }

    @Override
    public SlashRegistryType getSlashRegistryType() {
        return SlashRegistryType.CURRENCY_ITEMS;
    }

    @Override
    public int getRarityRank() {
        return 1;
    }

    @Override
    public Rarity getRarity() {
        return Rarities.Gears.get(this.getRarityRank());
    }

    @Override
    public int Weight() {
        if (this.getRarityRank() == 0) {
            return (Integer)ModConfig.INSTANCE.RarityWeightConfig.CURRENCY.COMMON_WEIGHT.get();
        }
        if (this.getRarityRank() == 1) {
            return (Integer)ModConfig.INSTANCE.RarityWeightConfig.CURRENCY.UNCOMMON_WEIGHT.get();
        }
        if (this.getRarityRank() == 2) {
            return (Integer)ModConfig.INSTANCE.RarityWeightConfig.CURRENCY.RARE_WEIGHT.get();
        }
        if (this.getRarityRank() == 3) {
            return (Integer)ModConfig.INSTANCE.RarityWeightConfig.CURRENCY.EPIC_WEIGHT.get();
        }
        if (this.getRarityRank() == 4) {
            return (Integer)ModConfig.INSTANCE.RarityWeightConfig.CURRENCY.LEGENDARY_WEIGHT.get();
        }
        return 0;
    }

    @Override
    public ItemStack getSalvageResult(float salvageBonus) {
        ItemStack stack = RecipeUtils.getSalvageStack(this);
        if (!stack.func_190926_b()) {
            int min = MathHelper.func_76125_a((int)(stack.func_190916_E() / 4), (int)1, (int)64);
            int max = MathHelper.func_76125_a((int)(stack.func_190916_E() / 2), (int)1, (int)64);
            min = this.tryIncreaseAmount(salvageBonus, min);
            max = this.tryIncreaseAmount(salvageBonus, max);
            int amount = RandomUtils.RandomRange(min, max);
            stack.func_190920_e(amount);
        }
        return stack;
    }

    @Override
    public boolean isSalvagable(ISalvagable.SalvageContext context) {
        return true;
    }
}

