/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.currency.loc_reqs;

import com.robertx22.mine_and_slash.database.currency.loc_reqs.BaseLocRequirement;
import com.robertx22.mine_and_slash.database.currency.loc_reqs.LocReqContext;
import com.robertx22.mine_and_slash.saveclasses.gearitem.GearItemEnum;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.util.text.ITextComponent;

public class GearEnumLocReq
extends BaseLocRequirement {
    public static final GearEnumLocReq AFFIXES = new GearEnumLocReq(x -> x.canGetAffixes());
    public static final GearEnumLocReq SETS = new GearEnumLocReq(x -> x.canGetSet());
    public static final GearEnumLocReq SECONDARY_STATS = new GearEnumLocReq(x -> x.canGetSecondaryStats());
    public static final GearEnumLocReq CAN_PRIMARY_STATS = new GearEnumLocReq(x -> x.canGetPrimaryStats());
    public static final GearEnumLocReq CAN_CHAOS_STATS = new GearEnumLocReq(x -> x.canGetChaosStats());
    public static final GearEnumLocReq REROLL_NUMBERS = new GearEnumLocReq(x -> x.canRerollNumbers());
    public static final GearEnumLocReq RUNED = new GearEnumLocReq(x -> x == GearItemEnum.RUNED);
    Predicate<GearItemEnum> gearsThatCanDoThis;

    private GearEnumLocReq(Predicate<GearItemEnum> pred) {
        this.gearsThatCanDoThis = pred;
    }

    @Override
    public ITextComponent getText() {
        ITextComponent comp = Words.AllowedOn.locName().func_150258_a(": ");
        List enums = Arrays.stream(GearItemEnum.values()).filter(x -> this.gearsThatCanDoThis.test((GearItemEnum)x)).collect(Collectors.toList());
        int count = 1;
        for (GearItemEnum x2 : enums) {
            comp.func_150257_a(x2.word().locName());
            if (count < enums.size()) {
                comp.func_150258_a(", ");
            }
            ++count;
        }
        return comp;
    }

    @Override
    public boolean isAllowed(LocReqContext context) {
        GearItemData gear;
        GearItemEnum genum;
        return context.data instanceof GearItemData && this.gearsThatCanDoThis.test(genum = (gear = (GearItemData)context.data).getGearEnum());
    }
}

