/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.currency.loc_reqs;

import com.robertx22.mine_and_slash.database.currency.loc_reqs.BaseLocRequirement;
import com.robertx22.mine_and_slash.database.currency.loc_reqs.LocReqContext;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import net.minecraft.util.text.ITextComponent;

public class OnlyOneUniqueRuneReq
extends BaseLocRequirement {
    private OnlyOneUniqueRuneReq() {
    }

    public static OnlyOneUniqueRuneReq getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public ITextComponent getText() {
        return Words.OnlyOneUniqueRune.locName();
    }

    @Override
    public boolean isAllowed(LocReqContext context) {
        if (context.data instanceof GearItemData) {
            GearItemData gear = (GearItemData)context.data;
            return gear.runes == null || !gear.runes.hasUniqueRune();
        }
        return false;
    }

    private static class SingletonHolder {
        private static final OnlyOneUniqueRuneReq INSTANCE = new OnlyOneUniqueRuneReq();

        private SingletonHolder() {
        }
    }
}

