/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.gearitemslots.bases;

import com.robertx22.mine_and_slash.data_generation.wrappers.StatModsHolder;
import com.robertx22.mine_and_slash.database.gearitemslots.WeaponDamageMulti;
import com.robertx22.mine_and_slash.database.gearitemslots.WeaponSwingCost;
import com.robertx22.mine_and_slash.database.gearitemslots.bases.PosStats;
import com.robertx22.mine_and_slash.database.gearitemslots.offhand.Shield;
import com.robertx22.mine_and_slash.database.gearitemslots.weapons.Axe;
import com.robertx22.mine_and_slash.database.gearitemslots.weapons.Bow;
import com.robertx22.mine_and_slash.database.gearitemslots.weapons.CrossBow;
import com.robertx22.mine_and_slash.database.gearitemslots.weapons.Sword;
import com.robertx22.mine_and_slash.database.gearitemslots.weapons.Trident;
import com.robertx22.mine_and_slash.database.gearitemslots.weapons.mechanics.NormalWeaponMechanic;
import com.robertx22.mine_and_slash.database.gearitemslots.weapons.mechanics.WeaponMechanic;
import com.robertx22.mine_and_slash.database.stats.StatMod;
import com.robertx22.mine_and_slash.database.stats.mods.flat.corestats.CoreStatFlat;
import com.robertx22.mine_and_slash.database.stats.mods.flat.defense.ArmorFlat;
import com.robertx22.mine_and_slash.database.stats.mods.flat.defense.DodgeRatingFlat;
import com.robertx22.mine_and_slash.database.stats.mods.flat.offense.SpellDamageFlat;
import com.robertx22.mine_and_slash.database.stats.mods.flat.resources.HealthFlat;
import com.robertx22.mine_and_slash.database.stats.mods.flat.resources.MagicShieldFlat;
import com.robertx22.mine_and_slash.database.stats.mods.flat.resources.ManaFlat;
import com.robertx22.mine_and_slash.database.stats.mods.generated.ElementalResistFlat;
import com.robertx22.mine_and_slash.database.stats.mods.generated.ElementalSpellDamageFlat;
import com.robertx22.mine_and_slash.database.stats.types.core_stats.Dexterity;
import com.robertx22.mine_and_slash.database.stats.types.core_stats.Intelligence;
import com.robertx22.mine_and_slash.database.stats.types.core_stats.Stamina;
import com.robertx22.mine_and_slash.database.stats.types.core_stats.Strength;
import com.robertx22.mine_and_slash.database.stats.types.core_stats.Vitality;
import com.robertx22.mine_and_slash.database.stats.types.core_stats.Wisdom;
import com.robertx22.mine_and_slash.database.unique_items.ISpecificStatReq;
import com.robertx22.mine_and_slash.database.unique_items.StatReq;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.registry.ISlashRegistryEntry;
import com.robertx22.mine_and_slash.registry.SlashRegistryType;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.Rarity;
import com.robertx22.mine_and_slash.saveclasses.player_stat_points.LvlPointStat;
import com.robertx22.mine_and_slash.uncommon.effectdatas.interfaces.WeaponTypes;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocName;
import com.robertx22.mine_and_slash.uncommon.interfaces.IBaseAutoLoc;
import com.robertx22.mine_and_slash.uncommon.interfaces.IWeighted;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.AxeItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.ShieldItem;
import net.minecraft.item.SwordItem;
import net.minecraft.item.TridentItem;
import top.theillusivec4.curios.api.CuriosAPI;

public abstract class GearItemSlot
implements IWeighted,
IAutoLocName,
ISlashRegistryEntry<GearItemSlot>,
ISpecificStatReq {
    public static StatReq.Size doubleArmorStatSize = StatReq.Size.SMALL;
    public static StatReq clothArmorReq = new StatReq(LvlPointStat.WISDOM, doubleArmorStatSize, LvlPointStat.INTELLIGENCE, doubleArmorStatSize);
    public static StatReq leatherArmorReq = new StatReq(LvlPointStat.DEXTERITY, doubleArmorStatSize, LvlPointStat.STAMINA, doubleArmorStatSize);
    public static StatReq plateArmorReq = new StatReq(LvlPointStat.VITALITY, doubleArmorStatSize, LvlPointStat.STRENGTH, doubleArmorStatSize);
    public static StatReq noReq = StatReq.nothing();
    private static HashMap<String, HashMap<Item, Boolean>> CACHED = new HashMap();

    public boolean isWeapon() {
        return this.slotType().equals((Object)GearSlotType.Weapon);
    }

    public WeaponTypes weaponType() {
        return WeaponTypes.None;
    }

    public abstract PlayStyle getPlayStyle();

    public boolean isMeleeWeapon() {
        return false;
    }

    public abstract EquipmentSlotType getVanillaSlotType();

    public WeaponDamageMulti weaponDamageMulti() {
        return new WeaponDamageMulti(1.0f);
    }

    public WeaponMechanic getWeaponMechanic() {
        return new NormalWeaponMechanic();
    }

    public WeaponSwingCost getSwingCosts() {
        return new WeaponSwingCost(5.0f);
    }

    public List<PosStats> clothPrimary() {
        return Arrays.asList(new PosStats(new MagicShieldFlat()));
    }

    public List<PosStats> leatherPrimary() {
        return Arrays.asList(new PosStats(new DodgeRatingFlat(), new HealthFlat().size(StatMod.Size.HALF)));
    }

    public List<PosStats> eleDmgs() {
        List<PosStats> list = new ElementalSpellDamageFlat(Elements.Nature).allSingleElementVariations().stream().map(x -> new PosStats((StatMod)x)).collect(Collectors.toList());
        list.add(new PosStats(new SpellDamageFlat()));
        return list;
    }

    public int cooldownTicks() {
        return 20;
    }

    public static boolean isGearOfThisType(GearItemSlot slot, Item item) {
        String id = slot.GUID();
        if (!CACHED.containsKey(id)) {
            CACHED.put(id, new HashMap());
        }
        if (CACHED.get(id).containsKey(item)) {
            return CACHED.get(id).get(item);
        }
        boolean bool = false;
        try {
            if (item instanceof ArmorItem) {
                if (slot.getVanillaSlotType() != null) {
                    if (slot.getVanillaSlotType().equals((Object)EquipmentSlotType.FEET)) {
                        bool = ((ArmorItem)item).func_185083_B_().equals((Object)EquipmentSlotType.FEET);
                    } else if (slot.getVanillaSlotType().equals((Object)EquipmentSlotType.CHEST)) {
                        bool = ((ArmorItem)item).func_185083_B_().equals((Object)EquipmentSlotType.CHEST);
                    } else if (slot.getVanillaSlotType().equals((Object)EquipmentSlotType.HEAD)) {
                        bool = ((ArmorItem)item).func_185083_B_().equals((Object)EquipmentSlotType.HEAD);
                    } else if (slot.getVanillaSlotType().equals((Object)EquipmentSlotType.LEGS)) {
                        bool = ((ArmorItem)item).func_185083_B_().equals((Object)EquipmentSlotType.LEGS);
                    }
                }
            } else if (slot.GUID().equals(Sword.INSTANCE.GUID())) {
                bool = item instanceof SwordItem;
            } else if (slot.GUID().equals(Trident.INSTANCE.GUID())) {
                bool = item instanceof TridentItem;
            } else if (slot.GUID().equals(Bow.INSTANCE.GUID())) {
                bool = item instanceof BowItem;
            } else if (slot.GUID().equals(Axe.INSTANCE.GUID())) {
                bool = item instanceof AxeItem;
            } else if (slot.GUID().equals(Shield.INSTANCE.GUID())) {
                bool = item instanceof ShieldItem;
            } else if (slot.GUID().equals(CrossBow.INSTANCE.GUID())) {
                bool = item instanceof CrossbowItem;
            } else if (slot.slotType().equals((Object)GearSlotType.Jewerly)) {
                bool = CuriosAPI.getCurioTags((Item)item).stream().anyMatch(x -> x.toString().contains(slot.GUID()));
            }
            CACHED.get(slot.GUID()).put(item, bool);
            return bool;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public abstract String resourceID();

    public static List<StatMod> leatherArmorSecondary() {
        ArrayList<StatMod> list = new ArrayList<StatMod>();
        list.add(new ArmorFlat());
        list.add(new CoreStatFlat(Stamina.INSTANCE));
        list.add(new CoreStatFlat(Dexterity.INSTANCE));
        list.addAll(GearItemSlot.allResists());
        return list;
    }

    public static List<StatMod> plateArmorSecondary() {
        ArrayList<StatMod> list = new ArrayList<StatMod>();
        list.add(new ArmorFlat());
        list.add(new CoreStatFlat(Vitality.INSTANCE));
        list.add(new CoreStatFlat(Strength.INSTANCE));
        list.addAll(GearItemSlot.allResists());
        return list;
    }

    public static List<StatMod> clothArmorSecondary() {
        ArrayList<StatMod> list = new ArrayList<StatMod>();
        list.add(new ArmorFlat().size(StatMod.Size.LOW));
        list.add(new ManaFlat().size(StatMod.Size.HALF_MORE));
        list.add(new CoreStatFlat(Intelligence.INSTANCE));
        list.add(new CoreStatFlat(Wisdom.INSTANCE));
        list.addAll(GearItemSlot.allResists());
        return list;
    }

    @Override
    public int getRarityRank() {
        return 0;
    }

    @Override
    public Rarity getRarity() {
        return Rarities.Gears.get(this.getRarityRank());
    }

    @Override
    public SlashRegistryType getSlashRegistryType() {
        return SlashRegistryType.GEAR_TYPE;
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locNameGroup() {
        return IBaseAutoLoc.AutoLocGroup.Gear_Slots;
    }

    public abstract GearSlotType slotType();

    public static List<StatMod> coreStatMods() {
        return new CoreStatFlat(Vitality.INSTANCE).generateAllPossibleStatVariations();
    }

    @Override
    public String locNameLangFileGUID() {
        return "mmorpg.gear_type." + this.formattedGUID();
    }

    public abstract List<PosStats> getPossiblePrimaryStats();

    public abstract StatModsHolder getPossibleSecondaryStats();

    public Item getDefaultItem() {
        return Items.field_190931_a;
    }

    public abstract HashMap<Integer, Item> getItemsForRaritiesMap();

    @Override
    public int Weight() {
        return 1000;
    }

    public static List<StatMod> allResists() {
        return new ElementalResistFlat(Elements.Physical).allSingleElementVariations();
    }

    public boolean isMageWeapon() {
        return false;
    }

    public Item getItemForRarity(int rarityNum) {
        if (this.getItemsForRaritiesMap().containsKey(rarityNum)) {
            return this.getItemsForRaritiesMap().get(rarityNum);
        }
        return this.getDefaultItem();
    }

    public static enum GearSlotType {
        Weapon,
        Armor,
        Jewerly,
        OffHand;

    }

    public static enum PlayStyle {
        MAGE,
        THIEF,
        WARRIOR,
        NONE;

    }
}

