/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.gearitemslots.weapons.mechanics;

import com.robertx22.mine_and_slash.database.IGUID;
import com.robertx22.mine_and_slash.database.gearitemslots.weapons.mechanics.HammerWeaponMechanic;
import com.robertx22.mine_and_slash.database.gearitemslots.weapons.mechanics.NormalWeaponMechanic;
import com.robertx22.mine_and_slash.database.stats.types.offense.PhysicalDamage;
import com.robertx22.mine_and_slash.onevent.entity.damage.DamageEventData;
import com.robertx22.mine_and_slash.uncommon.effectdatas.DamageEffect;
import com.robertx22.mine_and_slash.uncommon.effectdatas.EffectData;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.util.text.ITextComponent;

public abstract class WeaponMechanic
implements IGUID {
    private static HashMap<String, WeaponMechanic> ALL = new HashMap<String, WeaponMechanic>(){
        {
            this.put(new HammerWeaponMechanic().GUID(), new HammerWeaponMechanic());
            this.put(new NormalWeaponMechanic().GUID(), new NormalWeaponMechanic());
        }
    };

    public static WeaponMechanic get(String id) {
        return ALL.getOrDefault(id, new NormalWeaponMechanic());
    }

    public List<ITextComponent> tooltipDesc() {
        return Arrays.asList(new ITextComponent[0]);
    }

    protected boolean isPoweredAttack(DamageEventData data) {
        return data.sourceData.isAttackCooldownInSweepRange();
    }

    protected void doSpecialAttack(DamageEventData data) {
        this.doNormalAttack(data);
    }

    protected void doNormalAttack(DamageEventData data) {
        int num = (int)data.sourceData.getUnit().getCreateStat(PhysicalDamage.GUID).getRandomRangeValue();
        DamageEffect dmg = new DamageEffect(data.event, data.source, data.target, num, data.sourceData, data.targetData, EffectData.EffectTypes.BASIC_ATTACK, data.weaponData.GetBaseGearType().weaponType());
        dmg.setMultiplier(data.multiplier);
        dmg.Activate();
    }

    public void attack(DamageEventData data) {
        if (this.isPoweredAttack(data)) {
            data.multiplier = data.weaponData.GetBaseGearType().weaponDamageMulti().poweredDmgMulti;
            this.doSpecialAttack(data);
        } else {
            data.multiplier = data.weaponData.GetBaseGearType().weaponDamageMulti().normalDmgMulti;
            this.doNormalAttack(data);
        }
    }
}

