/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.loot_crates.bases;

import com.robertx22.mine_and_slash.database.loot_crates.bases.MapScoreEnum;
import com.robertx22.mine_and_slash.database.loot_crates.loot_crate_item.MapLootCrateItem;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.loot.LootInfo;
import com.robertx22.mine_and_slash.registry.ISlashRegistryEntry;
import com.robertx22.mine_and_slash.registry.SlashRegistryType;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.Rarity;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;

public abstract class LootCrate
implements ISlashRegistryEntry {
    public Item lootCrateItem() {
        return MapLootCrateItem.ITEM;
    }

    public abstract ITextComponent name();

    public abstract ItemStack generateStack(LootInfo var1);

    public float lotteryWinChance() {
        return 1.0f;
    }

    public boolean wonLottery() {
        return RandomUtils.roll(this.lotteryWinChance());
    }

    public abstract int maxItems();

    public ItemStack getCrateStack(int lvl, int mapTier, int score) {
        ItemStack stack = new ItemStack((IItemProvider)this.lootCrateItem());
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        stack.func_77978_p().func_74768_a(MapLootCrateItem.LVL, lvl);
        stack.func_77978_p().func_74768_a(MapLootCrateItem.TIER, mapTier);
        stack.func_77978_p().func_74778_a(MapLootCrateItem.ID, this.GUID());
        stack.func_77978_p().func_74778_a(MapLootCrateItem.SCORE, MapScoreEnum.byNumber(score).name());
        return stack;
    }

    public List<ItemStack> generateItems(LootInfo info) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        int amount = RandomUtils.RandomRange(this.maxItems() / 2, this.maxItems());
        if (RandomUtils.roll(1)) {
            amount *= 3;
        }
        while (items.size() < amount) {
            ItemStack stack = this.generateStack(info);
            if (stack == null || stack.func_190926_b()) continue;
            items.add(stack);
        }
        return items;
    }

    @Override
    public int Weight() {
        return this.getRarity().Weight();
    }

    @Override
    public int getRarityRank() {
        return 1;
    }

    @Override
    public Rarity getRarity() {
        return Rarities.Gears.get(this.getRarityRank());
    }

    @Override
    public SlashRegistryType getSlashRegistryType() {
        return SlashRegistryType.LOOT_CRATE;
    }
}

