/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.loot_crates.bases;

import com.robertx22.mine_and_slash.uncommon.capability.player.PlayerMapCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.Collectors;
import net.minecraft.entity.player.PlayerEntity;

public enum MapScoreEnum {
    BAD(1, 0.25f, Words.Bad, 1.0f),
    AVERAGE(2, 0.5f, Words.Average, 0.9f),
    GOOD(3, 0.7f, Words.Good, 0.8f),
    GREAT(4, 0.85f, Words.Great, 0.5f),
    AMAZING(5, 1.0f, Words.Amazing, 0.4f);

    static String SCORE_SYMBOL;
    public float timeNeeded = 0.0f;
    public float itemRewardMulti = 0.0f;
    public int number = 0;
    public Words word;

    private MapScoreEnum(int number, float itemRewardMulti, Words word, float timeNeeded) {
        this.number = number;
        this.itemRewardMulti = itemRewardMulti;
        this.word = word;
        this.timeNeeded = timeNeeded;
    }

    public static MapScoreEnum byNumber(int score) {
        return Arrays.asList(MapScoreEnum.values()).stream().filter(x -> x.number == score).findFirst().get();
    }

    public static MapScoreEnum getScore(PlayerEntity player) {
        PlayerMapCap.IPlayerMapData mapdata = Load.playerMapData(player);
        MapScoreEnum best = Arrays.stream(MapScoreEnum.values()).filter(x -> x.meetsTimeRequirement(mapdata)).collect(Collectors.toList()).stream().max(Comparator.comparing(v -> v.number)).get();
        return best;
    }

    public String getTooltipLine() {
        String text = "";
        for (int i = 0; i < this.number; ++i) {
            text = text + " " + SCORE_SYMBOL;
        }
        return text;
    }

    public boolean meetsTimeRequirement(PlayerMapCap.IPlayerMapData data) {
        return true;
    }

    static {
        SCORE_SYMBOL = "\u2764";
    }
}

