/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.loot_crates.loot_crate_item;

import com.robertx22.mine_and_slash.database.loot_crates.bases.LootCrate;
import com.robertx22.mine_and_slash.database.loot_crates.bases.MapScoreEnum;
import com.robertx22.mine_and_slash.loot.LootInfo;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.uncommon.localization.CLOC;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RegisterItemUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ObjectHolder;

public class MapLootCrateItem
extends Item {
    @ObjectHolder(value="mmorpg:loot_crate")
    public static final Item ITEM = null;
    public static String LVL = "LVL";
    public static String SCORE = "SCORE";
    public static String ID = "REGISTRY_ID";
    public static String TIER = "TIER";

    public MapLootCrateItem() {
        super(MapLootCrateItem.getProp());
        RegisterItemUtils.RegisterItemName(this, "loot_crate");
    }

    public String getHighlightTip(ItemStack stack, String displayName) {
        return CLOC.translate(this.name(stack));
    }

    public ITextComponent name(ItemStack stack) {
        return new StringTextComponent(TextFormatting.BOLD + "" + TextFormatting.DARK_PURPLE).func_150257_a(this.getCrate(stack).name());
    }

    public static Item.Properties getProp() {
        Item.Properties prop = new Item.Properties().func_200917_a(1);
        return prop;
    }

    public LootCrate getCrate(ItemStack stack) {
        return SlashRegistry.LootCrates().get(this.getID(stack));
    }

    public String getID(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74779_i(ID) != null) {
            return stack.func_77978_p().func_74779_i(ID);
        }
        return "";
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        try {
            LootCrate crate = this.getCrate(stack);
            int lvl = stack.func_77978_p().func_74762_e(LVL);
            MapScoreEnum score = MapScoreEnum.valueOf(stack.func_77978_p().func_74779_i(SCORE));
            int tier = stack.func_77978_p().func_74762_e(TIER);
            tooltip.clear();
            tooltip.add(this.name(stack));
            TooltipUtils.addEmpty(tooltip);
            tooltip.add(TooltipUtils.level(lvl));
            TooltipUtils.addEmpty(tooltip);
            tooltip.add(TooltipUtils.tier(tier));
            TooltipUtils.addEmpty(tooltip);
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.LIGHT_PURPLE + "Score: " + score.getTooltipLine()));
            TooltipUtils.addEmpty(tooltip);
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.BLUE + "Right click to open!"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (!world.field_72995_K) {
            try {
                try {
                    ItemStack stack = player.func_184586_b(hand);
                    LootCrate crate = SlashRegistry.LootCrates().get(stack.func_77978_p().func_74779_i(ID));
                    int lvl = stack.func_77978_p().func_74762_e(LVL);
                    MapScoreEnum score = MapScoreEnum.valueOf(stack.func_77978_p().func_74779_i(SCORE));
                    int tier = stack.func_77978_p().func_74762_e(TIER);
                    LootInfo info = new LootInfo(player);
                    info.level = lvl;
                    info.tier = tier;
                    stack.func_190918_g(1);
                    boolean wonLottery = crate.wonLottery();
                    if (wonLottery) {
                        // empty if block
                    }
                    List<ItemStack> items = crate.generateItems(info);
                    for (ItemStack istack : items) {
                        player.func_70099_a(istack, 1.0f);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new ActionResult(ActionResultType.PASS, (Object)player.func_184586_b(hand));
    }
}

