/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.rarities;

import com.google.common.base.Preconditions;
import com.robertx22.mine_and_slash.database.rarities.RarityTypeEnum;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.Rarity;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public abstract class BaseRaritiesContainer<T extends Rarity> {
    public int minRarity;
    public int maxRarity;
    public List<T> normalRarities;
    HashMap<Integer, T> map = new HashMap();

    public void updateFromDatapack(List<T> rarities) {
        Preconditions.checkArgument((rarities.size() == this.map.size() ? 1 : 0) != 0, (Object)"Rarities can't be added or removed through datapacks. This is a hard limitation.");
        this.map = new HashMap();
        rarities.forEach(x -> this.map.put(x.Rank(), x));
        this.onInit();
    }

    public final void onInit() {
        this.minRarity = this.getAllRarities().stream().min(Comparator.comparingInt(Rarity::Rank)).get().Rank();
        this.maxRarity = this.getAllRarities().stream().max(Comparator.comparingInt(Rarity::Rank)).get().Rank();
        this.normalRarities = this.getMap().values().stream().filter(x -> x.Rank() >= 0 && x.Rank() <= 4).collect(Collectors.toList());
    }

    public final HashMap<Integer, T> getMap() {
        return this.map;
    }

    public List<T> getNormalRarities() {
        return new ArrayList<T>(this.normalRarities);
    }

    protected void add(T r) {
        this.getMap().put(r.Rank(), r);
    }

    public List<T> getAllRarities() {
        return new ArrayList<T>(this.getMap().values());
    }

    public T random() {
        return (T)((Rarity)RandomUtils.weightedRandom(this.getNormalRarities()));
    }

    public final T get(int i) {
        if (i < this.minRarity) {
            try {
                throw new Exception("Rarity can't be less than " + this.minRarity);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (i > this.maxRarity) {
            try {
                throw new Exception("Rarity can't be more than " + this.maxRarity);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return (T)((Rarity)this.getMap().get(i));
    }

    public abstract RarityTypeEnum getType();
}

