/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.rarities;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.robertx22.mine_and_slash.database.MinMax;
import com.robertx22.mine_and_slash.database.rarities.IStatPercents;
import com.robertx22.mine_and_slash.database.rarities.SalvagableItem;
import com.robertx22.mine_and_slash.database.rarities.serialization.SerializedBaseRarity;
import com.robertx22.mine_and_slash.database.rarities.serialization.SerializedGearRarity;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IGearPart;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.Rarity;

public interface GearRarity
extends Rarity,
SalvagableItem,
IStatPercents {
    @Override
    default public JsonObject toJson() {
        JsonObject json = this.getRarityJsonObject();
        json.addProperty("affix_chance", (Number)this.AffixChance());
        json.addProperty("set_chance", (Number)this.SetChance());
        json.addProperty("rune_slots", (Number)this.runeSlots());
        json.addProperty("requirements_multi", (Number)Float.valueOf(this.requirementMulti()));
        json.addProperty("unidentified_chance", (Number)Float.valueOf(this.unidentifiedChance()));
        json.addProperty("salvage_lottery_chance", (Number)Float.valueOf(this.salvageLotteryWinChance()));
        json.add("secondary_stat_amount", (JsonElement)this.secondaryStatAmount().toJson());
        json.add("stat_percents", (JsonElement)this.StatPercents().toJson());
        json.add("primary_stat_percents", (JsonElement)this.primaryStatPercents().toJson());
        json.add("secondary_stat_percents", (JsonElement)this.secondaryStatPercents().toJson());
        json.add("unique_stat_percents", (JsonElement)this.uniqueStatPercents().toJson());
        json.add("affix_stat_percents", (JsonElement)this.affixStatPercents().toJson());
        return json;
    }

    @Override
    default public GearRarity fromJson(JsonObject json) {
        SerializedBaseRarity baseRarity = this.baseSerializedRarityFromJson(json);
        SerializedGearRarity rar = new SerializedGearRarity(baseRarity);
        rar.affixChance = json.get("affix_chance").getAsInt();
        rar.salvageLotteryChance = json.get("salvage_lottery_chance").getAsInt();
        rar.setChance = json.get("set_chance").getAsInt();
        rar.runeSlots = json.get("rune_slots").getAsInt();
        rar.unidentifiedChance = json.get("unidentified_chance").getAsInt();
        rar.requirementMulti = json.get("requirements_multi").getAsFloat();
        rar.statPercents = MinMax.getSerializer().fromJson(json.getAsJsonObject("stat_percents"));
        rar.affixStatPercents = MinMax.getSerializer().fromJson(json.getAsJsonObject("affix_stat_percents"));
        rar.secondaryStatPercents = MinMax.getSerializer().fromJson(json.getAsJsonObject("secondary_stat_percents"));
        rar.uniqueStatPercents = MinMax.getSerializer().fromJson(json.getAsJsonObject("unique_stat_percents"));
        rar.primaryStatPercents = MinMax.getSerializer().fromJson(json.getAsJsonObject("primary_stat_percents"));
        rar.secondaryStatsAmount = MinMax.getSerializer().fromJson(json.getAsJsonObject("secondary_stat_amount"));
        Preconditions.checkArgument((!this.StatPercents().isEmpty() ? 1 : 0) != 0);
        return rar;
    }

    default public MinMax getStatPercentsFor(IGearPart.Part part) {
        if (part == IGearPart.Part.PRIMARY_STATS) {
            return this.primaryStatPercents();
        }
        if (part == IGearPart.Part.SECONDARY_STATS) {
            return this.secondaryStatPercents();
        }
        if (part == IGearPart.Part.AFFIX) {
            return this.affixStatPercents();
        }
        if (part == IGearPart.Part.UNIQUE_STATS) {
            return this.uniqueStatPercents();
        }
        return this.StatPercents();
    }

    public MinMax primaryStatPercents();

    public MinMax secondaryStatPercents();

    public MinMax affixStatPercents();

    public MinMax uniqueStatPercents();

    public int AffixChance();

    public int SetChance();

    public int runeSlots();

    public MinMax secondaryStatAmount();

    public float itemTierPower();

    public float requirementMulti();

    public float unidentifiedChance();
}

