/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.requirements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.robertx22.mine_and_slash.data_generation.JsonUtils;
import com.robertx22.mine_and_slash.database.requirements.bases.GearRequestedFor;
import com.robertx22.mine_and_slash.database.requirements.bases.UniqueItemRequirement;
import com.robertx22.mine_and_slash.database.unique_items.IUnique;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.uncommon.wrappers.SText;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class ExactUniquesRequierement
extends UniqueItemRequirement<ExactUniquesRequierement> {
    List<String> uniquesGUIDS = new ArrayList<String>();

    public ExactUniquesRequierement() {
    }

    public ExactUniquesRequierement(IUnique unique) {
        this.uniquesGUIDS.add(unique.GUID());
    }

    public ExactUniquesRequierement(List<IUnique> uniques) {
        for (IUnique uniq : uniques) {
            this.uniquesGUIDS.add(uniq.GUID());
        }
    }

    @Override
    public boolean meetsRequierment(GearRequestedFor requested) {
        Boolean prev = super.meetsRequierment(requested);
        if (!prev.booleanValue()) {
            return false;
        }
        return this.uniquesGUIDS.contains(requested.gearData.uniqueStats.getUnique().GUID());
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.add("possible_uniques", (JsonElement)JsonUtils.stringListToJsonArray(this.uniquesGUIDS));
        return json;
    }

    @Override
    public ExactUniquesRequierement fromJson(JsonObject json) {
        try {
            ExactUniquesRequierement newobj = new ExactUniquesRequierement();
            newobj.uniquesGUIDS = JsonUtils.jsonArrayToStringList(json.getAsJsonArray("possible_uniques"));
            return newobj;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getJsonID() {
        return "exact_unique";
    }

    @Override
    public List<ITextComponent> GetTooltipString(TooltipInfo info) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        list.add((ITextComponent)new SText("Needs Exact Unique Gear: "));
        SText comp = new SText(TextFormatting.YELLOW + "");
        this.uniquesGUIDS.forEach(arg_0 -> ExactUniquesRequierement.lambda$GetTooltipString$0((ITextComponent)comp, arg_0));
        list.add((ITextComponent)comp);
        return list;
    }

    private static /* synthetic */ void lambda$GetTooltipString$0(ITextComponent comp, String x) {
        comp.func_150258_a(" ").func_150257_a(SlashRegistry.UniqueGears().get(x).locName());
    }
}

