/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.requirements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.robertx22.mine_and_slash.config.forge.ModConfig;
import com.robertx22.mine_and_slash.database.requirements.bases.BaseRequirement;
import com.robertx22.mine_and_slash.database.requirements.bases.GearRequestedFor;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.uncommon.wrappers.SText;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class LevelRequirement
extends BaseRequirement<LevelRequirement> {
    public int minLevel = 0;
    public int maxLevel = Integer.MAX_VALUE;

    private LevelRequirement(int minLevel) {
        this.minLevel = minLevel;
    }

    public LevelRequirement() {
    }

    public boolean equals(Object other) {
        if (other instanceof LevelRequirement) {
            LevelRequirement l = (LevelRequirement)other;
            return l.minLevel == this.minLevel && l.maxLevel == this.maxLevel;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.minLevel, this.maxLevel);
    }

    public int clampedMax() {
        return MathHelper.func_76125_a((int)this.maxLevel, (int)0, (int)((Integer)ModConfig.INSTANCE.Server.MAXIMUM_PLAYER_LEVEL.get()));
    }

    public static LevelRequirement none() {
        return new LevelRequirement(0, Integer.MAX_VALUE);
    }

    private LevelRequirement(int minLevel, int maxLevel) {
        this.minLevel = minLevel;
        this.maxLevel = maxLevel;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.add("min_level", (JsonElement)new JsonPrimitive((Number)this.minLevel));
        json.add("max_level", (JsonElement)new JsonPrimitive((Number)this.maxLevel));
        return json;
    }

    @Override
    public LevelRequirement fromJson(JsonObject json) {
        try {
            return new LevelRequirement(json.get("min_level").getAsInt(), json.get("max_level").getAsInt());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static LevelRequirement lowLVLOnly() {
        return new LevelRequirement(0, 10);
    }

    public static LevelRequirement midLVLOnly() {
        return new LevelRequirement(10, 25);
    }

    public static LevelRequirement highLVLOnly() {
        return new LevelRequirement(25, 50);
    }

    public static LevelRequirement endgameLVLOnly() {
        return new LevelRequirement(50, Integer.MAX_VALUE);
    }

    public static LevelRequirement fromLowLevel() {
        return new LevelRequirement(10);
    }

    public static LevelRequirement fromMidLevel() {
        return new LevelRequirement(25);
    }

    public static LevelRequirement fromHighLevel() {
        return new LevelRequirement(50);
    }

    @Override
    public boolean meetsRequierment(GearRequestedFor requested) {
        int maxPlayerlvl = (Integer)ModConfig.INSTANCE.Server.MAXIMUM_PLAYER_LEVEL.get();
        this.minLevel = MathHelper.func_76125_a((int)this.minLevel, (int)0, (int)maxPlayerlvl);
        this.maxLevel = MathHelper.func_76125_a((int)this.maxLevel, (int)0, (int)maxPlayerlvl);
        int level = requested.gearData.level;
        return level >= this.minLevel && level <= this.maxLevel;
    }

    @Override
    public String getJsonID() {
        return "level_req";
    }

    @Override
    public List<ITextComponent> GetTooltipString(TooltipInfo info) {
        return Arrays.asList(new ITextComponent[]{new SText(TextFormatting.YELLOW + "Level: " + this.minLevel + " - " + MathHelper.func_76125_a((int)this.maxLevel, (int)0, (int)((Integer)ModConfig.INSTANCE.Server.MAXIMUM_PLAYER_LEVEL.get())))});
    }
}

