/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.requirements;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.robertx22.mine_and_slash.data_generation.JsonUtils;
import com.robertx22.mine_and_slash.database.gearitemslots.bases.GearItemSlot;
import com.robertx22.mine_and_slash.database.gearitemslots.bases.armor.BaseBoots;
import com.robertx22.mine_and_slash.database.gearitemslots.bases.armor.BaseChest;
import com.robertx22.mine_and_slash.database.gearitemslots.bases.armor.BaseHelmet;
import com.robertx22.mine_and_slash.database.gearitemslots.bases.armor.BasePants;
import com.robertx22.mine_and_slash.database.gearitemslots.cloth.ClothBoots;
import com.robertx22.mine_and_slash.database.gearitemslots.cloth.ClothChest;
import com.robertx22.mine_and_slash.database.gearitemslots.cloth.ClothHelmet;
import com.robertx22.mine_and_slash.database.gearitemslots.cloth.ClothPants;
import com.robertx22.mine_and_slash.database.gearitemslots.curios.Bracelet;
import com.robertx22.mine_and_slash.database.gearitemslots.curios.Charm;
import com.robertx22.mine_and_slash.database.gearitemslots.curios.Necklace;
import com.robertx22.mine_and_slash.database.gearitemslots.curios.Ring;
import com.robertx22.mine_and_slash.database.gearitemslots.offhand.Shield;
import com.robertx22.mine_and_slash.database.gearitemslots.weapons.Staff;
import com.robertx22.mine_and_slash.database.requirements.bases.BaseRequirement;
import com.robertx22.mine_and_slash.database.requirements.bases.GearRequestedFor;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.uncommon.wrappers.SText;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class SlotRequirement
extends BaseRequirement<SlotRequirement> {
    public List<GearItemSlot> slots = new ArrayList<GearItemSlot>();

    public SlotRequirement() {
    }

    private SlotRequirement(GearItemSlot slot) {
        this.slots.add(slot);
    }

    private SlotRequirement(List<GearItemSlot> slots) {
        this.slots.addAll(slots);
    }

    @Override
    public boolean meetsRequierment(GearRequestedFor requested) {
        for (GearItemSlot slot : this.slots) {
            if (!requested.forSlot.getClass().isAssignableFrom(slot.getClass())) continue;
            return true;
        }
        return false;
    }

    public static SlotRequirement ChestAndShield() {
        SlotRequirement req = new SlotRequirement(SlotRequirement.chest().slots);
        req.slots.add(Shield.INSTANCE);
        return req;
    }

    public static SlotRequirement helmetCharmAndNecklace() {
        SlotRequirement req = new SlotRequirement(SlotRequirement.helmet().slots);
        req.slots.add(Necklace.INSTANCE);
        req.slots.add(Charm.INSTANCE);
        return req;
    }

    public static SlotRequirement ring() {
        return new SlotRequirement(Ring.INSTANCE);
    }

    public static SlotRequirement allExceptWeapon() {
        return new SlotRequirement(SlotRequirement.allSlotsExceptWeapon());
    }

    public static SlotRequirement slots(GearItemSlot ... slots) {
        return new SlotRequirement(Arrays.asList(slots));
    }

    public static SlotRequirement necklace() {
        return new SlotRequirement(Necklace.INSTANCE);
    }

    public static SlotRequirement charm() {
        return new SlotRequirement(Charm.INSTANCE);
    }

    public static SlotRequirement shield() {
        return new SlotRequirement(Shield.INSTANCE);
    }

    public static SlotRequirement staff() {
        return new SlotRequirement(Staff.INSTANCE);
    }

    public static SlotRequirement bracelet() {
        return new SlotRequirement(Bracelet.INSTANCE);
    }

    public static SlotRequirement chest() {
        return new SlotRequirement(SlashRegistry.GearTypes().getAll().values().stream().filter(x -> x instanceof BaseChest).collect(Collectors.toList()));
    }

    public static SlotRequirement pants() {
        return new SlotRequirement(SlashRegistry.GearTypes().getAll().values().stream().filter(x -> x instanceof BasePants).collect(Collectors.toList()));
    }

    public static SlotRequirement boots() {
        return new SlotRequirement(SlashRegistry.GearTypes().getAll().values().stream().filter(x -> x instanceof BaseBoots).collect(Collectors.toList()));
    }

    public static SlotRequirement helmet() {
        return new SlotRequirement(SlashRegistry.GearTypes().getAll().values().stream().filter(x -> x instanceof BaseHelmet).collect(Collectors.toList()));
    }

    public static SlotRequirement weaponsOnly() {
        return new SlotRequirement(SlotRequirement.weaponSlots());
    }

    public static SlotRequirement armorsOnly() {
        return new SlotRequirement(SlotRequirement.armorSlots());
    }

    public static SlotRequirement armorsOnlyNoOffHand() {
        return new SlotRequirement(SlotRequirement.armorSlotsNoOffHand());
    }

    public static SlotRequirement jewerlyOnly() {
        return new SlotRequirement(SlotRequirement.jewerlySlots());
    }

    public static SlotRequirement clothArmorOnly() {
        return new SlotRequirement(SlotRequirement.clothArmors());
    }

    static List<GearItemSlot> clothArmors() {
        ArrayList<GearItemSlot> list = new ArrayList<GearItemSlot>();
        list.add(ClothBoots.INSTANCE);
        list.add(ClothHelmet.INSTANCE);
        list.add(ClothChest.INSTANCE);
        list.add(ClothPants.INSTANCE);
        return list;
    }

    static List<GearItemSlot> weaponSlots() {
        return SlashRegistry.GearTypes().getAll().values().stream().filter(x -> x.slotType().equals((Object)GearItemSlot.GearSlotType.Weapon)).collect(Collectors.toList());
    }

    static List<GearItemSlot> armorSlots() {
        return SlashRegistry.GearTypes().getAll().values().stream().filter(x -> x.slotType().equals((Object)GearItemSlot.GearSlotType.Armor) || x.slotType().equals((Object)GearItemSlot.GearSlotType.OffHand)).collect(Collectors.toList());
    }

    static List<GearItemSlot> armorSlotsNoOffHand() {
        return SlashRegistry.GearTypes().getAll().values().stream().filter(x -> x.slotType().equals((Object)GearItemSlot.GearSlotType.Armor)).collect(Collectors.toList());
    }

    static List<GearItemSlot> allSlotsExceptWeapon() {
        return SlashRegistry.GearTypes().getAll().values().stream().filter(x -> !x.slotType().equals((Object)GearItemSlot.GearSlotType.Weapon)).collect(Collectors.toList());
    }

    static List<GearItemSlot> jewerlySlots() {
        return SlashRegistry.GearTypes().getAll().values().stream().filter(x -> x.slotType().equals((Object)GearItemSlot.GearSlotType.Jewerly)).collect(Collectors.toList());
    }

    @Override
    public String getJsonID() {
        return "slot_req";
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.add("slots", (JsonElement)JsonUtils.stringListToJsonArray(this.slots.stream().map(x -> x.GUID()).collect(Collectors.toList())));
        return json;
    }

    @Override
    public SlotRequirement fromJson(JsonObject json) {
        try {
            SlotRequirement newobj = new SlotRequirement();
            JsonArray array = json.getAsJsonArray("slots");
            newobj.slots = JsonUtils.jsonArrayToStringList(array).stream().map(x -> SlashRegistry.GearTypes().get((String)x)).collect(Collectors.toList());
            return newobj;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public List<ITextComponent> GetTooltipString(TooltipInfo info) {
        List<GearItemSlot> jewerly;
        List<GearItemSlot> weapons;
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        list.add((ITextComponent)new SText(TextFormatting.GREEN + "Allowed on: "));
        ArrayList<GearItemSlot> copy = new ArrayList<GearItemSlot>(this.slots);
        SText comp = new SText(TextFormatting.RED + "");
        List<GearItemSlot> armors = SlashRegistry.GearTypes().getFiltered(x -> x.slotType().equals((Object)GearItemSlot.GearSlotType.Armor));
        if (copy.containsAll(armors)) {
            copy.removeIf(x -> x.slotType().equals((Object)GearItemSlot.GearSlotType.Armor));
            comp.func_150258_a(" ").func_150257_a((ITextComponent)new SText("All Armors"));
        }
        if (copy.containsAll(weapons = SlashRegistry.GearTypes().getFiltered(x -> x.slotType().equals((Object)GearItemSlot.GearSlotType.Weapon)))) {
            copy.removeIf(x -> x.slotType().equals((Object)GearItemSlot.GearSlotType.Weapon));
            comp.func_150258_a(" ").func_150257_a((ITextComponent)new SText("All Weapons"));
        }
        if (copy.containsAll(jewerly = SlashRegistry.GearTypes().getFiltered(x -> x.slotType().equals((Object)GearItemSlot.GearSlotType.Jewerly)))) {
            copy.removeIf(x -> x.slotType().equals((Object)GearItemSlot.GearSlotType.Jewerly));
            comp.func_150258_a(" ").func_150257_a((ITextComponent)new SText("All Jewerly"));
        }
        copy.forEach(arg_0 -> SlotRequirement.lambda$GetTooltipString$17((ITextComponent)comp, arg_0));
        list.add((ITextComponent)comp);
        return list;
    }

    private static /* synthetic */ void lambda$GetTooltipString$17(ITextComponent comp, GearItemSlot x) {
        comp.func_150258_a(" ").func_150257_a(x.locName());
    }
}

