/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.requirements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.robertx22.mine_and_slash.database.requirements.bases.GearRequestedFor;
import com.robertx22.mine_and_slash.database.requirements.bases.UniqueItemRequirement;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.ITiered;
import com.robertx22.mine_and_slash.uncommon.wrappers.SText;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class UniqueTierRequirement
extends UniqueItemRequirement<UniqueTierRequirement> {
    int minTier = 0;
    int maxTier = Integer.MAX_VALUE;

    public UniqueTierRequirement(int minTier) {
        this.minTier = minTier;
    }

    public UniqueTierRequirement() {
    }

    public UniqueTierRequirement(int minTier, int maxTier) {
        this.minTier = minTier;
        this.maxTier = maxTier;
    }

    @Override
    public boolean meetsRequierment(GearRequestedFor requested) {
        Boolean superreq = super.meetsRequierment(requested);
        if (!superreq.booleanValue()) {
            return false;
        }
        int tier = requested.gearData.uniqueStats.getUnique().getTier();
        return tier >= this.minTier && tier <= this.maxTier;
    }

    @Override
    public String getJsonID() {
        return "unique_tier";
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.add("min_tier", (JsonElement)new JsonPrimitive((Number)this.minTier));
        json.add("max_tier", (JsonElement)new JsonPrimitive((Number)this.maxTier));
        return json;
    }

    @Override
    public UniqueTierRequirement fromJson(JsonObject json) {
        try {
            return new UniqueTierRequirement(json.get("min_tier").getAsInt(), json.get("max_tier").getAsInt());
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public List<ITextComponent> GetTooltipString(TooltipInfo info) {
        return Arrays.asList(new ITextComponent[]{new SText(TextFormatting.GOLD + "Requires Unique Gear of Tier: " + this.minTier + " - " + MathHelper.func_76125_a((int)this.maxTier, (int)0, (int)ITiered.getMaxTier()))});
    }
}

