/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.runes.base;

import com.robertx22.mine_and_slash.data_generation.models.IAutoModel;
import com.robertx22.mine_and_slash.data_generation.models.ItemModelManager;
import com.robertx22.mine_and_slash.database.currency.base.ICurrencyItemEffect;
import com.robertx22.mine_and_slash.database.currency.loc_reqs.BaseLocRequirement;
import com.robertx22.mine_and_slash.database.currency.loc_reqs.LocReqContext;
import com.robertx22.mine_and_slash.database.currency.loc_reqs.OnlyOneUniqueRuneReq;
import com.robertx22.mine_and_slash.database.currency.loc_reqs.RuneEmptySlotReq;
import com.robertx22.mine_and_slash.database.currency.loc_reqs.RuneLvlReq;
import com.robertx22.mine_and_slash.database.currency.loc_reqs.RuneNoDuplicateReq;
import com.robertx22.mine_and_slash.database.runes.base.BaseRune;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.saveclasses.item_classes.RuneItemData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Gear;
import com.robertx22.mine_and_slash.uncommon.datasaving.Rune;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocName;
import com.robertx22.mine_and_slash.uncommon.interfaces.IBaseAutoLoc;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class RuneItem
extends Item
implements IAutoLocName,
ICurrencyItemEffect,
IAutoModel {
    public int field_208075_l;
    public String rune;

    public RuneItem(BaseRune rune, int rarity) {
        super(new Item.Properties().func_200917_a(1).func_200915_b(0));
        this.field_208075_l = rarity;
        this.rune = rune.GUID();
    }

    @Override
    public void generateModel(ItemModelManager manager) {
        manager.generated(this);
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locNameGroup() {
        return IBaseAutoLoc.AutoLocGroup.Runes;
    }

    @Override
    public String locNameLangFileGUID() {
        return this.getRegistryName().toString();
    }

    @Override
    public String locNameForLangFile() {
        Object rar = Rarities.Runes.get(this.field_208075_l);
        return rar.textFormatting() + this.rune.toUpperCase(Locale.ROOT) + " - " + rar.locNameForLangFile() + " Rune";
    }

    @Override
    public String GUID() {
        return this.rune;
    }

    @Override
    public ItemStack ModifyItem(ItemStack stack, ItemStack currency) {
        GearItemData gear = Gear.Load(stack);
        RuneItemData rune = Rune.Load(currency);
        if (gear != null && rune != null) {
            gear.runes.insert(rune, gear);
            Gear.Save(stack, gear);
        }
        return stack;
    }

    @Override
    public boolean canItemBeModified(LocReqContext context) {
        for (BaseLocRequirement req : this.requirements()) {
            if (!req.isNotAllowed(context)) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<BaseLocRequirement> requirements() {
        return Arrays.asList(RuneEmptySlotReq.INSTANCE, OnlyOneUniqueRuneReq.getInstance(), RuneNoDuplicateReq.INSTANCE, RuneLvlReq.INSTANCE);
    }
}

