/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.runewords;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.robertx22.mine_and_slash.data_generation.JsonUtils;
import com.robertx22.mine_and_slash.data_generation.runewords.SerializableRuneword;
import com.robertx22.mine_and_slash.database.IGUID;
import com.robertx22.mine_and_slash.database.runes.base.BaseRune;
import com.robertx22.mine_and_slash.database.runes.base.BaseUniqueRune;
import com.robertx22.mine_and_slash.database.stats.StatMod;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.onevent.data_gen.ISerializable;
import com.robertx22.mine_and_slash.onevent.data_gen.ISerializedRegistryEntry;
import com.robertx22.mine_and_slash.registry.SlashRegistryType;
import com.robertx22.mine_and_slash.registry.empty_entries.EmptyRuneWord;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.Rarity;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocName;
import com.robertx22.mine_and_slash.uncommon.interfaces.IBaseAutoLoc;
import com.robertx22.mine_and_slash.uncommon.interfaces.IWeighted;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public abstract class RuneWord
implements IGUID,
IWeighted,
IAutoLocName,
ISerializedRegistryEntry<RuneWord>,
ISerializable<RuneWord> {
    public static RuneWord EMPTY = EmptyRuneWord.getInstance();

    public abstract List<StatMod> mods();

    @Override
    public abstract String GUID();

    @Override
    public String datapackFolder() {
        return this.runes().size() + "_runes/";
    }

    @Override
    public boolean isFromDatapack() {
        return true;
    }

    @Override
    public int getRarityRank() {
        return 1;
    }

    @Override
    public Rarity getRarity() {
        return Rarities.Runes.get(this.getRarityRank());
    }

    @Override
    public SlashRegistryType getSlashRegistryType() {
        return SlashRegistryType.RUNEWORD;
    }

    @Override
    public String locNameLangFileGUID() {
        return "mmorpg.word." + this.formattedGUID();
    }

    public abstract List<BaseRune> runes();

    public int size() {
        return this.runes().size();
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locNameGroup() {
        return IBaseAutoLoc.AutoLocGroup.Rune_Words;
    }

    @Override
    public int Weight() {
        return this.getRarity().Weight();
    }

    public String getRuneWordCombo() {
        String text = "";
        for (BaseRune item : this.runes()) {
            text = text + item.name().toUpperCase();
        }
        return text;
    }

    @Override
    public boolean isRegistryEntryValid() {
        if (!this.checkStatModsValidity(this.mods())) {
            return false;
        }
        if (this.runes().stream().filter(rune -> rune.isUnique()).count() > 1L) {
            System.out.println(this.GUID() + " needs more than 1 unique rune, runewords should not be able to require more than 1.!");
            return false;
        }
        if (this.runes().size() > 5) {
            System.out.println("Can't have more than 5 runes required in a runeword");
            return false;
        }
        return true;
    }

    public ITextComponent getRuneWordComboString() {
        StringTextComponent comp = new StringTextComponent("");
        int current = 0;
        for (BaseRune item : this.runes()) {
            String runetext = item.name().toUpperCase();
            if (current < this.runes().size() - 1) {
                runetext = runetext + " + ";
            }
            if (item instanceof BaseUniqueRune) {
                comp.func_150258_a(TextFormatting.YELLOW + runetext);
            } else {
                comp.func_150258_a(TextFormatting.GREEN + runetext);
            }
            ++current;
        }
        return comp;
    }

    public boolean runesMatch(String word) {
        return this.getRuneWordCombo().equals(word);
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = this.getDefaultJson();
        json.add("runes", (JsonElement)JsonUtils.stringListToJsonArray(this.runes().stream().map(x -> x.GUID()).collect(Collectors.toList())));
        JsonUtils.addStatMods(this.mods(), json, "mods");
        return json;
    }

    @Override
    public RuneWord fromJson(JsonObject json) {
        String guid = this.getGUIDFromJson(json);
        String lang = this.getLangNameStringFromJson(json);
        int weight = this.getWeightFromJson(json);
        int rarity = this.getRarityFromJson(json);
        List<String> runes = JsonUtils.jsonArrayToStringList(json.getAsJsonArray("runes"));
        List<StatMod> mods = JsonUtils.getStatMods(json, "mods");
        return new SerializableRuneword(rarity, weight, guid, mods, lang, runes);
    }
}

