/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.sets;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.robertx22.mine_and_slash.data_generation.sets.SerializableSet;
import com.robertx22.mine_and_slash.database.IGUID;
import com.robertx22.mine_and_slash.database.MinMax;
import com.robertx22.mine_and_slash.database.requirements.Requirements;
import com.robertx22.mine_and_slash.database.requirements.bases.GearRequestedFor;
import com.robertx22.mine_and_slash.database.stats.StatMod;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.db_lists.bases.IhasRequirements;
import com.robertx22.mine_and_slash.onevent.data_gen.ISerializable;
import com.robertx22.mine_and_slash.onevent.data_gen.ISerializedRegistryEntry;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.registry.SlashRegistryType;
import com.robertx22.mine_and_slash.registry.empty_entries.EmptySet;
import com.robertx22.mine_and_slash.saveclasses.WornSetData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.Rarity;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocName;
import com.robertx22.mine_and_slash.uncommon.interfaces.IBaseAutoLoc;
import com.robertx22.mine_and_slash.uncommon.interfaces.IWeighted;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.IRarity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Set
implements IWeighted,
IGUID,
IRarity,
IhasRequirements,
IAutoLocName,
ISerializedRegistryEntry<Set>,
ISerializable<Set> {
    public static Set EMPTY = new EmptySet();
    public int StatPercent = 100;

    @Override
    public boolean isFromDatapack() {
        return true;
    }

    @Override
    public Rarity getRarity() {
        return Rarities.Gears.get(this.getRarityRank());
    }

    @Override
    public int getRarityRank() {
        return 1;
    }

    @Override
    public SlashRegistryType getSlashRegistryType() {
        return SlashRegistryType.SET;
    }

    @Override
    public String locNameLangFileGUID() {
        return "mmorpg.set." + this.formattedGUID();
    }

    public MinMax statPercents() {
        return new MinMax(this.StatPercent, this.StatPercent);
    }

    @Override
    public boolean isRegistryEntryValid() {
        return this.checkStatModsValidity(new ArrayList<StatMod>(this.AllMods().values()));
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locNameGroup() {
        return IBaseAutoLoc.AutoLocGroup.Item_Sets;
    }

    @Override
    public int Weight() {
        return this.getRarity().Weight();
    }

    public abstract HashMap<Integer, StatMod> AllMods();

    @Override
    public boolean meetsRequirements(GearRequestedFor requested) {
        return this.requirements().satisfiesAllRequirements(requested);
    }

    public List<StatMod> getObtainedMods(WornSetData data) {
        ArrayList<StatMod> mods = new ArrayList<StatMod>();
        if (data.setGUID == this.GUID()) {
            for (Map.Entry<Integer, StatMod> mod : this.AllMods().entrySet()) {
                if (data.count < mod.getKey()) continue;
                mods.add(mod.getValue());
            }
        }
        return mods;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = this.getDefaultJson();
        json.add("requirements", (JsonElement)this.requirements().toJson());
        JsonObject map = new JsonObject();
        this.AllMods().entrySet().forEach(x -> map.addProperty(x.getKey() + "", ((StatMod)x.getValue()).GUID()));
        json.add("mods", (JsonElement)map);
        return json;
    }

    @Override
    public Set fromJson(JsonObject json) {
        String guid = this.getGUIDFromJson(json);
        String lang = this.getLangNameStringFromJson(json);
        int weight = this.getWeightFromJson(json);
        int rarity = this.getRarityFromJson(json);
        Requirements req = Requirements.EMPTY.fromJson(json.getAsJsonObject("requirements"));
        JsonObject mapJson = json.getAsJsonObject("mods");
        HashMap<Integer, StatMod> map = new HashMap<Integer, StatMod>();
        for (int i = 0; i < 10; ++i) {
            JsonElement obj = mapJson.get(i + "");
            if (obj == null) continue;
            map.put(i, SlashRegistry.StatMods().get(obj.getAsString()));
        }
        return new SerializableSet(rarity, weight, map, guid, lang, req);
    }
}

