/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells;

import com.robertx22.mine_and_slash.database.spells.SpellUtils;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.SpellCastContext;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;

public class ProjectileCastOptions {
    BaseSpell spell;
    Function<World, Entity> projectile;
    LivingEntity caster;
    public float apart = 3.0f;
    public float shootSpeed = 1.0f;
    public int projectilesAmount = 1;
    SpellCastContext ctx;

    public ProjectileCastOptions(SpellCastContext ctx) {
        this.spell = ctx.spell;
        this.projectile = ctx.spell.getImmutableConfigs().newEntitySummoner();
        this.caster = ctx.caster;
        this.ctx = ctx;
    }

    private void playSound(Entity en) {
        if (this.ctx.spell.getImmutableConfigs().sound() != null) {
            this.ctx.caster.field_70170_p.func_217384_a(null, en, this.ctx.spell.getImmutableConfigs().sound(), SoundCategory.HOSTILE, 1.0f, 1.0f);
        }
    }

    public void cast() {
        World world = this.caster.field_70170_p;
        if (this.projectilesAmount > 1) {
            float addYaw = 0.0f;
            for (int i = 0; i < this.projectilesAmount; ++i) {
                if (i < this.projectilesAmount / 2) {
                    addYaw -= this.apart / (float)this.projectilesAmount;
                } else if (i == this.projectilesAmount / 2) {
                    addYaw = 0.0f;
                } else if (i > this.projectilesAmount / 2) {
                    addYaw += this.apart / (float)this.projectilesAmount;
                }
                AbstractArrowEntity en = (AbstractArrowEntity)SpellUtils.getSpellEntity(this.ctx.configForSummonedEntities, this.projectile.apply(world), this.spell, this.caster);
                SpellUtils.setupProjectileForCasting(en, this.caster, this.shootSpeed, this.caster.field_70125_A, this.caster.field_70177_z + addYaw);
                this.caster.field_70170_p.func_217376_c((Entity)en);
                this.playSound((Entity)en);
            }
        } else {
            AbstractArrowEntity en = (AbstractArrowEntity)SpellUtils.getSpellEntity(this.ctx.configForSummonedEntities, this.projectile.apply(world), this.spell, this.caster);
            SpellUtils.setupProjectileForCasting(en, this.caster, this.shootSpeed, this.caster.field_70125_A, this.caster.field_70177_z);
            this.caster.field_70170_p.func_217376_c((Entity)en);
            this.playSound((Entity)en);
        }
    }
}

