/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells;

import com.robertx22.mine_and_slash.database.spells.entities.bases.ISpellEntity;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.SpellCastContext;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.EntityCalcSpellConfigs;
import com.robertx22.mine_and_slash.saveclasses.EntitySpellData;
import com.robertx22.mine_and_slash.saveclasses.ResourcesData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.effectdatas.SpellHealEffect;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSpawnGlobalEntityPacket;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class SpellUtils {
    public static void summonLightningStrike(Entity entity) {
        LightningBoltEntity lightningboltentity = new LightningBoltEntity(entity.field_70170_p, entity.func_226277_ct_() + 0.5, entity.func_226278_cu_(), entity.func_226281_cx_() + 0.5, true);
        SpellUtils.addLightningBolt((ServerWorld)entity.field_70170_p, lightningboltentity);
    }

    public static void addLightningBolt(ServerWorld world, LightningBoltEntity entityIn) {
        world.func_73046_m().func_184103_al().func_148543_a((PlayerEntity)null, entityIn.func_226277_ct_(), entityIn.func_226278_cu_(), entityIn.func_226281_cx_(), 50.0, world.func_201675_m().func_186058_p(), (IPacket)new SSpawnGlobalEntityPacket((Entity)entityIn));
    }

    public static void setupProjectileForCasting(AbstractArrowEntity projectile, LivingEntity caster, float speed) {
        Vec3d pos = caster.func_174791_d();
        projectile.func_70107_b(pos.field_72450_a, caster.func_226278_cu_() + (double)caster.func_70047_e() - (double)0.1f, pos.field_72449_c);
        projectile.func_184547_a((Entity)caster, caster.field_70125_A, caster.field_70177_z, 0.0f, speed, 1.0f);
    }

    public static void castTripleProjectileInCone(EntityCalcSpellConfigs config, float apart, BaseSpell spell, Function<World, AbstractArrowEntity> projectile, LivingEntity caster, float speed) {
        World world = caster.field_70170_p;
        for (int i = 0; i < 3; ++i) {
            float f = 0.0f;
            if (i == 0) {
                f = apart;
            }
            if (i == 2) {
                f = -apart;
            }
            AbstractArrowEntity en = (AbstractArrowEntity)SpellUtils.getSpellEntity(config, (Entity)projectile.apply(world), spell, caster);
            SpellUtils.setupProjectileForCasting(en, caster, speed, caster.field_70125_A, caster.field_70177_z + (f *= 10.0f));
            caster.field_70170_p.func_217376_c((Entity)en);
        }
    }

    public static void setupProjectileForCasting(AbstractArrowEntity projectile, LivingEntity caster, float speed, float pitch, float yaw) {
        Vec3d pos = caster.func_174791_d();
        projectile.func_70107_b(pos.field_72450_a, caster.func_226278_cu_() + (double)caster.func_70047_e() - (double)0.1f, pos.field_72449_c);
        projectile.func_184547_a((Entity)caster, pitch, yaw, 0.0f, speed, 1.0f);
    }

    public static <T extends Entity> T getSpellEntity(EntityCalcSpellConfigs config, T spellEntity, BaseSpell spell, LivingEntity caster) {
        ISpellEntity se = (ISpellEntity)spellEntity;
        int lifeInTicks = se.getDefaultLifeInTicks();
        EntitySpellData syncData = new EntitySpellData(spell, caster, config);
        se.setSpellData(syncData);
        se.initSpellEntity();
        return spellEntity;
    }

    public static void heal(BaseSpell spell, LivingEntity en, float amount) {
        SpellHealEffect heal = new SpellHealEffect(new ResourcesData.Context(Load.Unit((ICapabilityProvider)en), en, ResourcesData.Type.HEALTH, amount, ResourcesData.Use.RESTORE, spell));
        heal.Activate();
    }

    public static void healCaster(SpellCastContext ctx) {
        SpellHealEffect heal = new SpellHealEffect(new ResourcesData.Context(ctx.data, ctx.caster, ResourcesData.Type.HEALTH, (float)ctx.getConfigFor(ctx.ability).getCalc(ctx.spellsCap, ctx.ability).getCalculatedValue(ctx.data, ctx.spellsCap, ctx.ability), ResourcesData.Use.RESTORE, ctx.spell));
        heal.Activate();
    }

    public static void healCasterMana(SpellCastContext ctx) {
        SpellHealEffect heal = new SpellHealEffect(new ResourcesData.Context(ctx.data, ctx.caster, ResourcesData.Type.MANA, (float)ctx.getConfigFor(ctx.ability).getCalc(ctx.spellsCap, ctx.ability).getCalculatedValue(ctx.data, ctx.spellsCap, ctx.ability), ResourcesData.Use.RESTORE, ctx.spell));
        heal.Activate();
    }
}

