/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells.entities.bases;

import com.robertx22.mine_and_slash.database.spells.entities.bases.IMyRenderAsItem;
import com.robertx22.mine_and_slash.database.spells.entities.bases.ISpellEntity;
import com.robertx22.mine_and_slash.saveclasses.EntitySpellData;
import com.robertx22.mine_and_slash.uncommon.datasaving.EntitySpellDataSaving;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import org.jline.utils.Log;

public abstract class BaseInvisibleEntity
extends Entity
implements IMyRenderAsItem,
ISpellEntity {
    EntitySpellData spellData;

    public BaseInvisibleEntity(EntityType type, World world) {
        super(type, world);
        this.func_189654_d(true);
        this.func_213317_d(new Vec3d(0.0, 0.0, 0.0));
        this.func_184224_h(true);
    }

    public abstract void onTick();

    public void func_70071_h_() {
        if (this.spellData == null || this.spellData.getCaster(this.field_70170_p) == null) {
            Log.info((Object[])new Object[]{"Removing spell entity because data or caster is null. This happens sometimes and is normal, i'm just logging to see how often it happens."});
            this.func_70106_y();
        } else {
            try {
                super.func_70071_h_();
                this.onTick();
                if (this.field_70173_aa > this.getLifeInTicks() && this.getLifeInTicks() != -1) {
                    this.func_70106_y();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public ItemStack getItem() {
        return ItemStack.field_190927_a;
    }

    protected void func_70037_a(CompoundNBT nbt) {
        this.spellData = EntitySpellDataSaving.Load(nbt);
    }

    protected void func_213281_b(CompoundNBT nbt) {
        EntitySpellDataSaving.Save(nbt, this.spellData);
    }

    @Nullable
    public LivingEntity getCaster() {
        return this.getSpellData().getCaster(this.field_70170_p);
    }

    protected void func_70088_a() {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean func_90999_ad() {
        return false;
    }

    public boolean func_96092_aw() {
        return false;
    }

    @Override
    public EntitySpellData getSpellData() {
        return this.spellData;
    }

    @Override
    public void setSpellData(EntitySpellData data) {
        this.spellData = data;
    }

    public void writeSpawnData(PacketBuffer buf) {
        CompoundNBT nbt = new CompoundNBT();
        this.func_213281_b(nbt);
        buf.func_150786_a(nbt);
    }

    public void readSpawnData(PacketBuffer buf) {
        CompoundNBT nbt = buf.func_150793_b();
        this.func_70037_a(nbt);
    }
}

