/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells.entities.bases;

import com.robertx22.mine_and_slash.database.spells.entities.bases.IMyRenderAsItem;
import com.robertx22.mine_and_slash.database.spells.entities.bases.ISpellEntity;
import com.robertx22.mine_and_slash.saveclasses.EntitySpellData;
import com.robertx22.mine_and_slash.uncommon.datasaving.EntitySpellDataSaving;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.EntityFinder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import org.jline.utils.Log;

public abstract class EntityBaseProjectile
extends AbstractArrowEntity
implements IProjectile,
IMyRenderAsItem,
ISpellEntity {
    EntitySpellData spellData;
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private Block inTile;
    protected boolean field_70254_i;
    public int throwableShake;
    private int ticksInGround;
    private int ticksInAir;
    private int deathTime = 80;
    private int airProcTime;
    private boolean doGroundProc;
    public Entity ignoreEntity;

    public abstract double radius();

    protected ItemStack func_184550_j() {
        return ItemStack.field_190927_a;
    }

    protected boolean onExpireProc(LivingEntity caster) {
        return true;
    }

    public Iterable<ItemStack> func_184193_aE() {
        return new ArrayList<ItemStack>();
    }

    public void func_184201_a(EquipmentSlotType slotIn, ItemStack stack) {
    }

    public boolean getDoExpireProc() {
        return this.doGroundProc;
    }

    public int getTicksInAir() {
        return this.ticksInAir;
    }

    public int getTicksInGround() {
        return this.ticksInGround;
    }

    public void setTicksInAir(int newVal) {
        this.ticksInAir = newVal;
    }

    public void setTicksInGround(int newVal) {
        this.ticksInGround = newVal;
    }

    public int getAirProcTime() {
        return this.airProcTime;
    }

    public void setAirProcTime(int newVal) {
        this.airProcTime = newVal;
    }

    public int getDeathTime() {
        return this.deathTime;
    }

    public void setDeathTime(int newVal) {
        this.deathTime = newVal;
    }

    public void setDoExpireProc(boolean newVal) {
        this.doGroundProc = newVal;
    }

    public EntityBaseProjectile(EntityType<? extends Entity> type, World worldIn) {
        super(type, worldIn);
        this.setDeathTime(this.getDefaultLifeInTicks());
    }

    @Nullable
    public LivingEntity getEntityHit(RayTraceResult result, double radius) {
        List<LivingEntity> entities;
        EntityRayTraceResult enres = null;
        if (result instanceof EntityRayTraceResult) {
            enres = (EntityRayTraceResult)result;
        }
        if (enres != null && enres.func_216348_a() instanceof LivingEntity) {
            if (!enres.func_216348_a().func_70089_S()) {
                return null;
            }
            if (enres.func_216348_a() != this.getCaster()) {
                return (LivingEntity)enres.func_216348_a();
            }
        }
        if ((entities = EntityFinder.start(this.getCaster(), LivingEntity.class, this.func_174791_d()).radius(radius).build()).size() > 0) {
            LivingEntity closest = entities.get(0);
            for (LivingEntity en : entities) {
                if (en == closest || !(this.func_70032_d((Entity)en) < this.func_70032_d((Entity)closest))) continue;
                closest = en;
            }
            if (!closest.func_70089_S()) {
                // empty if block
            }
            return closest;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.func_213317_d(new Vec3d(x, y, z));
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 57.29577951308232);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
    }

    public abstract void onTick();

    public final void func_70071_h_() {
        if (this.spellData == null || this.spellData.getCaster(this.field_70170_p) == null) {
            Log.info((Object[])new Object[]{"Removing spell entity because data or caster is null. This happens sometimes and is normal, i'm just logging to see how often it happens."});
            this.func_70106_y();
        } else {
            try {
                super.func_70071_h_();
                this.onTick();
                if (this.field_70254_i) {
                    ++this.ticksInGround;
                } else {
                    ++this.ticksInAir;
                }
                if (this.field_70173_aa >= this.getDeathTime()) {
                    this.onExpireProc(this.getCaster());
                    this.func_70106_y();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Nullable
    protected EntityRayTraceResult func_213866_a(Vec3d pos, Vec3d posPlusMotion) {
        return ProjectileHelper.func_221271_a((World)this.field_70170_p, (Entity)this, (Vec3d)pos, (Vec3d)posPlusMotion, (AxisAlignedBB)this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0), e -> !e.func_175149_v() && e.func_70067_L() && e instanceof LivingEntity && e != this.getCaster() && e != this.ignoreEntity);
    }

    protected void func_184549_a(RayTraceResult raytraceResultIn) {
        RayTraceResult.Type raytraceresult$type = raytraceResultIn.func_216346_c();
        if (raytraceresult$type == RayTraceResult.Type.ENTITY) {
            this.onImpact(raytraceResultIn);
            this.func_184185_a(SoundEvents.field_187775_eP, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
        } else if (raytraceresult$type == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult blockraytraceresult = (BlockRayTraceResult)raytraceResultIn;
            BlockState blockstate = this.field_70170_p.func_180495_p(blockraytraceresult.func_216350_a());
            Vec3d vec3d = blockraytraceresult.func_216347_e().func_178786_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.func_213317_d(vec3d);
            Vec3d vec3d1 = vec3d.func_72432_b().func_186678_a((double)0.05f);
            this.field_70165_t -= vec3d1.field_72450_a;
            this.field_70163_u -= vec3d1.field_72448_b;
            this.field_70161_v -= vec3d1.field_72449_c;
            this.field_70254_i = true;
            this.onImpact((RayTraceResult)blockraytraceresult);
            blockstate.func_215690_a(this.field_70170_p, blockstate, blockraytraceresult, (Entity)this);
        }
    }

    protected abstract void onImpact(RayTraceResult var1);

    public void func_213281_b(CompoundNBT nbt) {
        nbt.func_74768_a("xTile", this.xTile);
        nbt.func_74768_a("yTile", this.yTile);
        nbt.func_74768_a("zTile", this.zTile);
        nbt.func_74774_a("shake", (byte)this.throwableShake);
        nbt.func_74774_a("inGround", (byte)(this.field_70254_i ? 1 : 0));
        nbt.func_74757_a("doGroundProc", this.getDoExpireProc());
        nbt.func_74768_a("airProcTime", this.getAirProcTime());
        nbt.func_74768_a("deathTime", this.getDeathTime());
        EntitySpellDataSaving.Save(nbt, this.spellData);
    }

    public void func_70037_a(CompoundNBT nbt) {
        this.xTile = nbt.func_74762_e("xTile");
        this.yTile = nbt.func_74762_e("yTile");
        this.zTile = nbt.func_74762_e("zTile");
        this.throwableShake = nbt.func_74771_c("shake") & 0xFF;
        this.field_70254_i = nbt.func_74771_c("inGround") == 1;
        this.setDoExpireProc(nbt.func_74767_n("doGroundProc"));
        this.setAirProcTime(nbt.func_74762_e("airProcTime"));
        this.setDeathTime(nbt.func_74762_e("deathTime"));
        this.spellData = EntitySpellDataSaving.Load(nbt);
    }

    protected void setPos(LivingEntity caster) {
        Vec3d look = caster.func_70040_Z();
        this.func_70107_b(caster.field_70165_t - look.field_72450_a, caster.field_70163_u - look.field_72448_b + 1.3, caster.field_70161_v - look.field_72449_c);
    }

    @Nullable
    public LivingEntity getCaster() {
        return this.getSpellData().getCaster(this.field_70170_p);
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean isValidTarget(Entity target) {
        return true;
    }

    public boolean func_90999_ad() {
        return false;
    }

    public boolean func_96092_aw() {
        return false;
    }

    @Override
    public EntitySpellData getSpellData() {
        return this.spellData;
    }

    @Override
    public void setSpellData(EntitySpellData data) {
        this.spellData = data;
    }

    public void writeSpawnData(PacketBuffer buf) {
        CompoundNBT nbt = new CompoundNBT();
        this.func_213281_b(nbt);
        buf.func_150786_a(nbt);
    }

    public void readSpawnData(PacketBuffer buf) {
        CompoundNBT nbt = buf.func_150793_b();
        this.func_70037_a(nbt);
    }
}

