/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells.entities.bases;

import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.SC;
import com.robertx22.mine_and_slash.saveclasses.EntitySpellData;
import com.robertx22.mine_and_slash.saveclasses.ResourcesData;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.effectdatas.SpellDamageEffect;
import com.robertx22.mine_and_slash.uncommon.effectdatas.SpellHealEffect;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import net.minecraft.entity.LivingEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public interface ISpellEntity
extends IEntityAdditionalSpawnData {
    default public void initSpellEntity() {
    }

    default public int durationInTicks() {
        if (this.getSpellData() == null) {
            return 0;
        }
        return this.getSpellData().configs.get(SC.DURATION_TICKS).intValue();
    }

    public EntitySpellData getSpellData();

    public void setSpellData(EntitySpellData var1);

    default public int getDefaultLifeInTicks() {
        return 200;
    }

    default public Elements getElement() {
        return this.getSpellData().getSpell().getElement();
    }

    default public int getLifeInTicks() {
        return this.getSpellData().lifeInTicks;
    }

    default public SpellDamageEffect dealSpellDamageTo(LivingEntity target) {
        return this.dealSpellDamageTo(target, new Options());
    }

    default public SpellDamageEffect getSetupSpellDamage(LivingEntity target) {
        return this.dealSpellDamageTo(target, new Options().activatesEffect(false));
    }

    default public SpellDamageEffect getSetupSpellDamage(LivingEntity target, Options opt) {
        return this.dealSpellDamageTo(target, opt.activatesEffect(false));
    }

    default public SpellHealEffect healTarget(LivingEntity target) {
        return this.healTarget(target, new Options().activatesEffect(false));
    }

    default public SpellHealEffect healTarget(LivingEntity target, Options opt) {
        EntitySpellData data = this.getSpellData();
        LivingEntity caster = data.getCaster(target.field_70170_p);
        BaseSpell spell = data.getSpell();
        EntityCap.UnitData casterData = Load.Unit((ICapabilityProvider)caster);
        int num = this.getSpellData().configs.calc.getCalculatedValue(casterData, Load.spells(caster), spell);
        SpellHealEffect heal = new SpellHealEffect(new ResourcesData.Context(caster, target, ResourcesData.Type.HEALTH, (float)num, ResourcesData.Use.RESTORE, spell));
        if (opt.activateEffect) {
            heal.Activate();
        }
        return heal;
    }

    default public SpellDamageEffect dealSpellDamageTo(LivingEntity target, Options opt) {
        EntitySpellData data = this.getSpellData();
        LivingEntity caster = data.getCaster(target.field_70170_p);
        BaseSpell spell = data.getSpell();
        EntityCap.UnitData casterData = Load.Unit((ICapabilityProvider)caster);
        int num = data.configs.calc.getCalculatedValue(casterData, Load.spells(caster), spell);
        SpellDamageEffect dmg = new SpellDamageEffect(caster, target, num, casterData, Load.Unit((ICapabilityProvider)target), data.getSpell());
        if (!opt.knockback) {
            dmg.removeKnockback();
        }
        dmg.element = spell.getElement();
        if (opt.activateEffect) {
            dmg.Activate();
        }
        return dmg;
    }

    public static class Options {
        public boolean knockback = true;
        public boolean activateEffect = true;

        public Options activatesEffect(boolean bool) {
            this.activateEffect = bool;
            return this;
        }

        public Options knockbacks(boolean bool) {
            this.knockback = bool;
            return this;
        }
    }
}

