/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells.entities.cloud;

import com.robertx22.mine_and_slash.database.spells.SpellUtils;
import com.robertx22.mine_and_slash.database.spells.entities.bases.BaseCloudEntity;
import com.robertx22.mine_and_slash.database.spells.entities.proj.RangerArrowEntity;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.SC;
import com.robertx22.mine_and_slash.mmorpg.registers.common.EntityRegister;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.GeometryUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.SoundUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;

public class ArrowStormEntity
extends BaseCloudEntity {
    public static int ARROWS_PER_SUMMON = 16;

    public ArrowStormEntity(World world) {
        super(EntityRegister.ARROW_STORM, world);
    }

    public ArrowStormEntity(EntityType type, World world) {
        super(type, world);
    }

    public ArrowStormEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        super(EntityRegister.ARROW_STORM, world);
    }

    @Override
    public void initSpellEntity() {
    }

    @Override
    public void onHit(LivingEntity entity) {
    }

    @Override
    public void summonFallParticle(Vec3d p) {
    }

    @Override
    public void onTick() {
        int tickrate = this.getSpellData().configs.get(SC.TICK_RATE).intValue();
        super.onTick();
        if (this.field_70173_aa % tickrate == 0) {
            LivingEntity caster = this.getCaster();
            if (!this.field_70170_p.field_72995_K) {
                for (int i = 0; i < ARROWS_PER_SUMMON; ++i) {
                    float yRandom = (float)RandomUtils.RandomRange(1, 100) / 40.0f;
                    float height = 4.0f;
                    Vec3d p = GeometryUtils.getRandomHorizontalPosInRadiusCircle(this.field_70165_t, this.field_70163_u + (double)height + (double)yRandom, this.field_70161_v, this.radius());
                    RangerArrowEntity en = SpellUtils.getSpellEntity(this.getSpellData().configs, new RangerArrowEntity(this.field_70170_p), this.getSpellData().getSpell(), caster);
                    SpellUtils.setupProjectileForCasting(en, caster, 1.5f);
                    en.func_213317_d(new Vec3d(0.0, -1.0, 0.0));
                    en.func_70012_b(p.field_72450_a, p.field_72448_b, p.field_72449_c, 0.0f, 0.0f);
                    caster.field_70170_p.func_217376_c((Entity)en);
                    SoundUtils.playSound((Entity)en, SoundEvents.field_187737_v, 1.0f, 1.0f);
                }
            }
        }
    }

    public float radius() {
        return 2.5f;
    }
}

