/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells.entities.proj;

import com.robertx22.mine_and_slash.database.spells.entities.bases.EntityBaseProjectile;
import com.robertx22.mine_and_slash.database.spells.entities.bases.ISpellEntity;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.SC;
import com.robertx22.mine_and_slash.mmorpg.registers.common.EntityRegister;
import com.robertx22.mine_and_slash.saveclasses.EntitySpellData;
import com.robertx22.mine_and_slash.uncommon.effectdatas.SpellDamageEffect;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.EntityFinder;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.GeometryUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ParticleUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.SoundUtils;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;

public class FireBombEntity
extends EntityBaseProjectile {
    public FireBombEntity(EntityType<? extends Entity> type, World world) {
        super(type, world);
    }

    public FireBombEntity(World worldIn) {
        super(EntityRegister.FIRE_BOMB, worldIn);
    }

    public FireBombEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        super(EntityRegister.FIRE_BOMB, world);
    }

    @Override
    public double radius() {
        return 3.5;
    }

    @Override
    protected void onImpact(RayTraceResult result) {
    }

    @Override
    public ItemStack getItem() {
        return new ItemStack((IItemProvider)Items.field_151044_h);
    }

    @Override
    public void onTick() {
        EntitySpellData sdata = this.getSpellData();
        int RADIUS = sdata.configs.get(SC.RADIUS).intValue();
        if ((this.field_70254_i || this.field_70173_aa % 5 == 0) && !this.field_70170_p.field_72995_K) {
            LivingEntity caster = this.getCaster();
            if (caster == null) {
                return;
            }
            List<LivingEntity> entities = EntityFinder.start(caster, LivingEntity.class, this.func_174791_d()).radius(RADIUS).build();
            if (entities.size() > 0) {
                this.func_70106_y();
                SoundUtils.playSound((Entity)this, SoundEvents.field_187539_bB, 1.0f, 1.0f);
                Vec3d p = GeometryUtils.getRandomHorizontalPosInRadiusCircle(this.func_174791_d().func_72441_c(0.0, (double)0.2f, 0.0), RADIUS);
                entities.forEach(x -> {
                    SpellDamageEffect dmg = this.dealSpellDamageTo((LivingEntity)x, new ISpellEntity.Options().knockbacks(false).activatesEffect(false));
                    dmg.Activate();
                });
            }
        }
        if (this.field_70170_p.field_72995_K && this.field_70173_aa % 2 == 0) {
            for (int i = 0; i < 20; ++i) {
                Vec3d p = GeometryUtils.getRandomHorizontalPosInRadiusCircle(this.func_174791_d().func_72441_c(0.0, (double)0.2f, 0.0), RADIUS);
                ParticleUtils.spawn((IParticleData)ParticleTypes.field_197601_L, this.field_70170_p, p);
                ParticleUtils.spawn((IParticleData)ParticleTypes.field_197631_x, this.field_70170_p, p);
            }
        }
    }
}

