/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells.entities.proj;

import com.robertx22.mine_and_slash.database.spells.entities.bases.EntityBaseProjectile;
import com.robertx22.mine_and_slash.database.spells.entities.bases.ISpellEntity;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.SC;
import com.robertx22.mine_and_slash.mmorpg.registers.common.EntityRegister;
import com.robertx22.mine_and_slash.mmorpg.registers.common.ParticleRegister;
import com.robertx22.mine_and_slash.uncommon.effectdatas.SpellDamageEffect;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.EntityFinder;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.GeometryUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ParticleUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.SoundUtils;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;

public class LightningTotemEntity
extends EntityBaseProjectile {
    public LightningTotemEntity(EntityType<? extends Entity> type, World world) {
        super(type, world);
    }

    public LightningTotemEntity(World worldIn) {
        super(EntityRegister.LIGHTNING_TOTEM, worldIn);
    }

    public LightningTotemEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        super(EntityRegister.LIGHTNING_TOTEM, world);
    }

    @Override
    public double radius() {
        return 3.5;
    }

    @Override
    protected void onImpact(RayTraceResult result) {
    }

    @Override
    public ItemStack getItem() {
        return new ItemStack((IItemProvider)Items.field_190929_cY);
    }

    @Override
    public void onTick() {
        int tickRate = this.getSpellData().configs.get(SC.TICK_RATE).intValue();
        if (this.field_70173_aa % tickRate == 0) {
            if (!this.field_70170_p.field_72995_K) {
                List<LivingEntity> entities = EntityFinder.start(this.getCaster(), LivingEntity.class, this.func_174791_d()).radius(this.radius()).build();
                entities.forEach(x -> {
                    SpellDamageEffect dmg = this.dealSpellDamageTo((LivingEntity)x, new ISpellEntity.Options().activatesEffect(false).knockbacks(false));
                    dmg.Activate();
                    SoundUtils.playSound((Entity)this, SoundEvents.field_187745_eA, 1.0f, 1.0f);
                });
            } else {
                SoundUtils.playSound((Entity)this, SoundEvents.field_187745_eA, 1.0f, 1.0f);
            }
        }
        if (this.field_70254_i && this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 80; ++i) {
                Vec3d p = GeometryUtils.getRandomPosInRadiusCircle(this.func_174791_d(), (float)this.radius());
                ParticleUtils.spawn((IParticleData)ParticleRegister.THUNDER, this.field_70170_p, p);
            }
        }
    }
}

