/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells.entities.proj;

import com.robertx22.mine_and_slash.database.spells.entities.bases.EntityBaseProjectile;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.SpellCastContext;
import com.robertx22.mine_and_slash.database.spells.spell_classes.hunting.ImbueSpell;
import com.robertx22.mine_and_slash.mmorpg.registers.common.EntityRegister;
import com.robertx22.mine_and_slash.potion_effects.ranger.ImbueEffect;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.effectdatas.SpellDamageEffect;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.GeometryUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ParticleUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.SoundUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.network.FMLPlayMessages;

public class RangerArrowEntity
extends EntityBaseProjectile {
    public boolean imbued = false;

    public RangerArrowEntity(EntityType<? extends Entity> type, World world) {
        super(type, world);
    }

    public RangerArrowEntity(World worldIn) {
        super(EntityRegister.RANGER_ARROW, worldIn);
    }

    public RangerArrowEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        super(EntityRegister.RANGER_ARROW, world);
    }

    @Override
    public void initSpellEntity() {
        try {
            this.imbued = this.getSpellData().getCaster(this.field_70170_p).func_70644_a((Effect)ImbueEffect.getInstance());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public double radius() {
        return 1.0;
    }

    @Override
    public void onTick() {
        if (this.imbued && this.field_70170_p.field_72995_K && this.field_70173_aa > 1) {
            for (int i = 0; i < 1; ++i) {
                Vec3d p = GeometryUtils.getRandomPosInRadiusCircle(this.func_174791_d(), 0.15f);
                ParticleUtils.spawn((IParticleData)ParticleTypes.field_197607_R, this.field_70170_p, p);
            }
        }
    }

    public void onHit(LivingEntity entity) {
        try {
            LivingEntity caster = this.getCaster();
            BaseSpell spell = this.getSpellData().getSpell();
            SpellDamageEffect dmg = this.getSetupSpellDamage(entity);
            if (this.imbued) {
                float add = ImbueSpell.getInstance().getCalculation(new SpellCastContext(caster, 0, ImbueSpell.getInstance())).getCalculatedValue(Load.Unit((ICapabilityProvider)caster), Load.spells(caster), ImbueSpell.getInstance());
                dmg.number += add;
            }
            dmg.Activate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void onImpact(RayTraceResult result) {
        try {
            LivingEntity entityHit = this.getEntityHit(result, 0.3);
            if (entityHit != null) {
                if (this.field_70170_p.field_72995_K) {
                    SoundUtils.playSound((Entity)this, SoundEvents.field_187543_bD, 1.0f, 0.9f);
                }
                if (!entityHit.field_70170_p.field_72995_K) {
                    this.onHit(entityHit);
                }
            } else if (this.field_70170_p.field_72995_K) {
                SoundUtils.playSound((Entity)this, SoundEvents.field_187843_fX, 0.7f, 0.9f);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.func_70106_y();
    }

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74757_a("imbued", this.imbued);
    }

    @Override
    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.imbued = nbt.func_74767_n("imbued");
    }

    @Override
    public ItemStack getItem() {
        return new ItemStack((IItemProvider)Items.field_190931_a);
    }
}

