/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells.entities.proj;

import com.robertx22.mine_and_slash.database.spells.entities.bases.EntityBaseProjectile;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.SC;
import com.robertx22.mine_and_slash.mmorpg.registers.common.EntityRegister;
import com.robertx22.mine_and_slash.potion_effects.bases.PotionEffectUtils;
import com.robertx22.mine_and_slash.potion_effects.ranger.WeakenEffect;
import com.robertx22.mine_and_slash.saveclasses.EntitySpellData;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.EntityFinder;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.GeometryUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ParticleUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.SoundUtils;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;

public class WeakenTrapEntity
extends EntityBaseProjectile {
    public WeakenTrapEntity(EntityType<? extends Entity> type, World world) {
        super(type, world);
    }

    public WeakenTrapEntity(World worldIn) {
        super(EntityRegister.WEAKEN_TRAP, worldIn);
    }

    public WeakenTrapEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        super(EntityRegister.WEAKEN_TRAP, world);
    }

    @Override
    public double radius() {
        return 3.0;
    }

    @Override
    protected void onImpact(RayTraceResult result) {
    }

    @Override
    public ItemStack getItem() {
        return new ItemStack((IItemProvider)Items.field_221737_dE);
    }

    @Override
    public void onTick() {
        EntitySpellData sdata = this.getSpellData();
        int RADIUS = sdata.configs.get(SC.RADIUS).intValue();
        if ((this.field_70254_i || this.field_70173_aa % 5 == 0) && !this.field_70170_p.field_72995_K) {
            LivingEntity caster = this.getCaster();
            if (caster == null) {
                return;
            }
            List<LivingEntity> entities = EntityFinder.start(caster, LivingEntity.class, this.func_174791_d()).radius(RADIUS).build();
            if (entities.size() > 0) {
                this.func_70106_y();
                SoundUtils.playSound((Entity)this, SoundEvents.field_187825_fO, 1.0f, 1.0f);
                Vec3d p = GeometryUtils.getRandomHorizontalPosInRadiusCircle(this.func_174791_d().func_72441_c(0.0, (double)0.2f, 0.0), RADIUS);
                ParticleUtils.spawn((IParticleData)ParticleTypes.field_197613_f, this.field_70170_p, p);
                entities.forEach(x -> PotionEffectUtils.apply(WeakenEffect.INSTANCE, this.getCaster(), x));
            }
        }
        if (this.field_70170_p.field_72995_K && this.field_70173_aa % 2 == 0) {
            for (int i = 0; i < 10; ++i) {
                Vec3d p = GeometryUtils.getRandomHorizontalPosInRadiusCircle(this.func_174791_d().func_72441_c(0.0, (double)0.2f, 0.0), RADIUS);
                ParticleUtils.spawn((IParticleData)ParticleTypes.field_197607_R, this.field_70170_p, p);
                ParticleUtils.spawn((IParticleData)ParticleTypes.field_218421_R, this.field_70170_p, p);
            }
        }
    }
}

