/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.spells.entities.proj;

import com.robertx22.mine_and_slash.database.spells.entities.bases.EntityBaseProjectile;
import com.robertx22.mine_and_slash.database.spells.entities.bases.ISpellEntity;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.SC;
import com.robertx22.mine_and_slash.mmorpg.registers.common.EntityRegister;
import com.robertx22.mine_and_slash.mmorpg.registers.common.ParticleRegister;
import com.robertx22.mine_and_slash.saveclasses.EntitySpellData;
import com.robertx22.mine_and_slash.uncommon.effectdatas.SpellDamageEffect;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.EntityFinder;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.GeometryUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ParticleUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.SoundUtils;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;

public class WhirlpoolEntity
extends EntityBaseProjectile {
    public WhirlpoolEntity(EntityType<? extends Entity> type, World world) {
        super(type, world);
    }

    public WhirlpoolEntity(World worldIn) {
        super(EntityRegister.WHIRPOOL, worldIn);
    }

    public WhirlpoolEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        super(EntityRegister.WHIRPOOL, world);
    }

    @Override
    public double radius() {
        return 3.5;
    }

    @Override
    protected void onImpact(RayTraceResult result) {
    }

    @Override
    public ItemStack getItem() {
        return new ItemStack((IItemProvider)Items.field_205158_fa);
    }

    @Override
    public void onTick() {
        EntitySpellData sdata = this.getSpellData();
        int TICK_RATE = sdata.configs.get(SC.TICK_RATE).intValue();
        int RADIUS = sdata.configs.get(SC.RADIUS).intValue();
        if (this.field_70254_i || this.field_70173_aa > 30) {
            if (this.field_70173_aa % TICK_RATE == 0) {
                if (!this.field_70170_p.field_72995_K) {
                    LivingEntity caster = this.getCaster();
                    if (caster == null) {
                        return;
                    }
                    List<LivingEntity> entities = EntityFinder.start(caster, LivingEntity.class, this.func_174791_d()).radius(RADIUS).build();
                    entities.forEach(x -> {
                        SpellDamageEffect dmg = this.dealSpellDamageTo((LivingEntity)x, new ISpellEntity.Options().knockbacks(false).activatesEffect(false));
                        dmg.Activate();
                        x.func_195064_c(new EffectInstance(Effects.field_76421_d, 5, 5));
                        SoundUtils.playSound((Entity)this, SoundEvents.field_204779_bd, 1.0f, 1.0f);
                    });
                } else {
                    Vec3d p = this.func_174791_d();
                    this.field_70170_p.func_184134_a(p.field_72450_a, p.field_72448_b, p.field_72449_c, SoundEvents.field_203253_U, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                }
            }
            if (this.field_70254_i && this.field_70170_p.field_72995_K) {
                float yUp = 0.05f;
                for (float rad = 1.0f; rad < (float)RADIUS; rad += 1.0f) {
                    yUp += 0.1f;
                    for (int i = 0; i < 40; ++i) {
                        Vec3d p = GeometryUtils.getRandomHorizontalPosInRadiusCircle(this.func_174791_d().func_72441_c(0.0, (double)yUp, 0.0), rad);
                        ParticleUtils.spawn((IParticleData)ParticleRegister.BUBBLE, this.field_70170_p, p);
                        ParticleUtils.spawn((IParticleData)ParticleTypes.field_205167_W, this.field_70170_p, p);
                        ParticleUtils.spawn((IParticleData)ParticleTypes.field_218422_X, this.field_70170_p, p);
                    }
                }
                Vec3d p = this.func_174791_d();
                this.field_70170_p.func_184134_a(p.field_72450_a, p.field_72448_b, p.field_72449_c, SoundEvents.field_203282_jc, SoundCategory.BLOCKS, 0.2f, 0.9f, false);
            }
        }
    }
}

